/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user.mapping.evaluation;

import io.imunity.scim.config.AttributeDefinitionWithMapping;
import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.config.SchemaType;
import io.imunity.scim.config.SchemaWithMapping;
import io.imunity.scim.user.User;
import io.imunity.scim.user.mapping.evaluation.EvaluationResult;
import io.imunity.scim.user.mapping.evaluation.EvaluatorContext;
import io.imunity.scim.user.mapping.evaluation.MappingEvaluator;
import io.imunity.scim.user.mapping.evaluation.MappingEvaluatorRegistry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.engine.api.mvel.CachingMVELGroupProvider;
import pl.edu.icm.unity.exceptions.EngineException;

public class UserSchemaEvaluator {
    private final MappingEvaluatorRegistry mappingEvaluatorRegistry;
    private final SCIMEndpointDescription configuration;

    UserSchemaEvaluator(SCIMEndpointDescription configuration, MappingEvaluatorRegistry mappingEvaluatorRegistry) {
        this.mappingEvaluatorRegistry = mappingEvaluatorRegistry;
        this.configuration = configuration;
    }

    public Map<String, Object> evalUserSchema(User user, List<SchemaWithMapping> schemas, CachingMVELGroupProvider cachingMVELGroupProvider) throws EngineException {
        LinkedHashMap<String, Object> attributeEvaluationResult = new LinkedHashMap<String, Object>();
        for (SchemaWithMapping basicSchema : schemas.stream().filter(s -> s.type.equals((Object)SchemaType.USER_CORE) && s.enable).collect(Collectors.toList())) {
            this.evalSchema(basicSchema, user, cachingMVELGroupProvider).forEach(attributeEvaluationResult::put);
        }
        for (SchemaWithMapping schema : schemas.stream().filter(s -> s.type.equals((Object)SchemaType.USER) && s.enable).collect(Collectors.toList())) {
            attributeEvaluationResult.put(schema.id, this.evalSchema(schema, user, cachingMVELGroupProvider));
        }
        return attributeEvaluationResult;
    }

    private Map<String, Object> evalSchema(SchemaWithMapping schema, User user, CachingMVELGroupProvider cachingMVELGroupProvider) throws EngineException {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (AttributeDefinitionWithMapping attributeWithMapping : schema.attributesWithMapping) {
            MappingEvaluator evaluator = (MappingEvaluator)this.mappingEvaluatorRegistry.getByName(attributeWithMapping.attributeMapping.getEvaluatorId());
            EvaluationResult eval = evaluator.eval(attributeWithMapping, EvaluatorContext.builder().withUser(user).withGroupProvider(cachingMVELGroupProvider).withScimEndpointDescription(this.configuration).build(), this.mappingEvaluatorRegistry);
            if (!eval.value.isPresent()) continue;
            ret.put(eval.attributeName, eval.value.get());
        }
        return ret;
    }

    @Component
    public static class UserSchemaEvaluatorFactory {
        private MappingEvaluatorRegistry mappingEvaluatorRegistry;

        public UserSchemaEvaluatorFactory(MappingEvaluatorRegistry mappingEvaluatorRegistry) {
            this.mappingEvaluatorRegistry = mappingEvaluatorRegistry;
        }

        public UserSchemaEvaluator getService(SCIMEndpointDescription configuration) {
            return new UserSchemaEvaluator(configuration, this.mappingEvaluatorRegistry);
        }
    }
}

