/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user.mapping.evaluation;

import io.imunity.scim.schema.SCIMAttributeType;
import io.imunity.scim.user.User;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.AttributeValueConverter;
import pl.edu.icm.unity.exceptions.IllegalAttributeValueException;
import pl.edu.icm.unity.types.basic.AttributeExt;
import pl.edu.icm.unity.types.basic.Identity;

@Component
class UnityToSCIMDataConverter {
    private static final Logger log = Log.getLogger((String)"unity.server.scim", UnityToSCIMDataConverter.class);
    private final AttributeValueConverter attrValueConverter;

    UnityToSCIMDataConverter(AttributeValueConverter attrValueConverter) {
        this.attrValueConverter = attrValueConverter;
    }

    Optional<Object> convertUserAttributeToType(User user, String attributeName, SCIMAttributeType type) throws IllegalAttributeValueException {
        Optional<AttributeExt> attribute = user.attributes.stream().filter(a -> a.getName().equals(attributeName)).findFirst();
        if (attribute.isPresent() && !attribute.get().getValues().isEmpty()) {
            return Optional.ofNullable(this.convertToType(this.attrValueConverter.internalValuesToObjectValues(attribute.get().getName(), attribute.get().getValues()).get(0), type));
        }
        return Optional.empty();
    }

    Optional<Object> convertUserIdentityToType(User user, String identityType, SCIMAttributeType type) {
        Optional<Identity> identity = user.identities.stream().filter(a -> a.getTypeId().equals(identityType)).findFirst();
        if (identity.isPresent() && !identity.get().getValue().isEmpty()) {
            return Optional.ofNullable(this.convertToType(identity.get().getValue(), type));
        }
        return Optional.empty();
    }

    Object convertToType(Object value, SCIMAttributeType type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case STRING: {
                return this.convertToString(value);
            }
            case BOOLEAN: {
                return this.convertToBoolean(value);
            }
            case DATETIME: {
                return this.convertToDateTime(value);
            }
        }
        log.warn("Can not convert from " + value.getClass() + " to " + type);
        return null;
    }

    private Instant convertToDateTime(Object value) {
        if (value instanceof Date) {
            return ((Date)value).toInstant();
        }
        if (value instanceof LocalDate) {
            return Instant.from((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toInstant();
        }
        if (value instanceof String) {
            return Instant.parse((String)value);
        }
        log.warn("Can not convert to date from " + value.getClass());
        return null;
    }

    private String convertToString(Object value) {
        return value.toString();
    }

    private Boolean convertToBoolean(Object value) {
        String booleanValue;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String && ((booleanValue = (String)value).equalsIgnoreCase("true") || booleanValue.equalsIgnoreCase("false"))) {
            return Boolean.valueOf(booleanValue);
        }
        log.warn("Can not convert to boolean from " + value.getClass() + ", value=" + value);
        return null;
    }
}

