/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user.mapping.evaluation;

import io.imunity.scim.config.AttributeDefinitionWithMapping;
import io.imunity.scim.config.SimpleAttributeMapping;
import io.imunity.scim.user.mapping.evaluation.DataArrayResolver;
import io.imunity.scim.user.mapping.evaluation.EvaluationResult;
import io.imunity.scim.user.mapping.evaluation.EvaluatorContext;
import io.imunity.scim.user.mapping.evaluation.MVELEvaluator;
import io.imunity.scim.user.mapping.evaluation.MappingEvaluator;
import io.imunity.scim.user.mapping.evaluation.MappingEvaluatorRegistry;
import io.imunity.scim.user.mapping.evaluation.UnityToSCIMDataConverter;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.exceptions.EngineException;

@Component
class SimpleMappingEvaluator
implements MappingEvaluator {
    private static final Logger log = Log.getLogger((String)"unity.server.scim", SimpleMappingEvaluator.class);
    private final DataArrayResolver dataArrayResolver;
    private final UnityToSCIMDataConverter targetDataConverter;
    private final MVELEvaluator mvelEvaluator;

    SimpleMappingEvaluator(DataArrayResolver dataArrayResolver, UnityToSCIMDataConverter targetDataConverter, MVELEvaluator mvelEvaluator) {
        this.dataArrayResolver = dataArrayResolver;
        this.targetDataConverter = targetDataConverter;
        this.mvelEvaluator = mvelEvaluator;
    }

    @Override
    public String getId() {
        return "Simple";
    }

    @Override
    public EvaluationResult eval(AttributeDefinitionWithMapping attributeDefinitionWithMapping, EvaluatorContext context, MappingEvaluatorRegistry registry) throws EngineException {
        log.debug("Eval simple mapping for attribute {}", (Object)attributeDefinitionWithMapping.attributeDefinition.name);
        SimpleAttributeMapping mapping = (SimpleAttributeMapping)attributeDefinitionWithMapping.attributeMapping;
        return attributeDefinitionWithMapping.attributeDefinition.multiValued ? this.evalMulti(attributeDefinitionWithMapping, context, registry, mapping) : this.evalSingle(attributeDefinitionWithMapping, context, registry, mapping);
    }

    private EvaluationResult evalSingle(AttributeDefinitionWithMapping attributeDefinitionWithMapping, EvaluatorContext context, MappingEvaluatorRegistry registry, SimpleAttributeMapping mapping) throws EngineException {
        Optional<Object> value = Optional.empty();
        switch (mapping.dataValue.type) {
            case MVEL: {
                value = Optional.ofNullable(this.targetDataConverter.convertToType(this.mvelEvaluator.evalMVEL(mapping.dataValue.value.get(), context), attributeDefinitionWithMapping.attributeDefinition.type));
                break;
            }
            case ATTRIBUTE: {
                value = this.targetDataConverter.convertUserAttributeToType(context.user, mapping.dataValue.value.get(), attributeDefinitionWithMapping.attributeDefinition.type);
                break;
            }
            case IDENTITY: {
                value = this.targetDataConverter.convertUserIdentityToType(context.user, mapping.dataValue.value.get(), attributeDefinitionWithMapping.attributeDefinition.type);
                break;
            }
            case ARRAY: {
                value = Optional.ofNullable(context.arrayObj == null ? null : this.targetDataConverter.convertToType(context.arrayObj, attributeDefinitionWithMapping.attributeDefinition.type));
                break;
            }
            default: {
                throw new UnsupportedOperationException(mapping.dataValue.type + " dataValue type is not supported by single simple mapping");
            }
        }
        return EvaluationResult.builder().withAttributeName(attributeDefinitionWithMapping.attributeDefinition.name).withValue(value).build();
    }

    private EvaluationResult evalMulti(AttributeDefinitionWithMapping attributeDefinitionWithMapping, EvaluatorContext context, MappingEvaluatorRegistry registry, SimpleAttributeMapping mapping) throws EngineException {
        if (attributeDefinitionWithMapping.attributeMapping.getDataArray().isEmpty()) {
            return EvaluationResult.builder().withAttributeName(attributeDefinitionWithMapping.attributeDefinition.name).build();
        }
        ArrayList evalRet = new ArrayList();
        block4: for (Object arrayObj : this.dataArrayResolver.resolve(mapping.getDataArray().get(), context)) {
            switch (mapping.dataValue.type) {
                case MVEL: {
                    Optional.ofNullable(this.targetDataConverter.convertToType(this.mvelEvaluator.evalMVEL(mapping.dataValue.value.get(), EvaluatorContext.builder().withUser(context.user).withArrayObj(arrayObj).withScimEndpointDescription(context.scimEndpointDescription).withGroupProvider(context.groupProvider).build()), attributeDefinitionWithMapping.attributeDefinition.type)).ifPresent(c -> evalRet.add(c));
                    continue block4;
                }
                case ARRAY: {
                    Optional.ofNullable(this.targetDataConverter.convertToType(arrayObj, attributeDefinitionWithMapping.attributeDefinition.type)).ifPresent(c -> evalRet.add(c));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException(mapping.dataValue.type + " dataValue type is not supported in single simple mapping");
        }
        return EvaluationResult.builder().withAttributeName(attributeDefinitionWithMapping.attributeDefinition.name).withValue(Optional.ofNullable(evalRet.isEmpty() ? null : evalRet)).build();
    }
}

