/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user.mapping.evaluation;

import io.imunity.scim.config.AttributeDefinitionWithMapping;
import io.imunity.scim.config.ReferenceAttributeMapping;
import io.imunity.scim.user.mapping.evaluation.DataArrayResolver;
import io.imunity.scim.user.mapping.evaluation.EvaluationResult;
import io.imunity.scim.user.mapping.evaluation.EvaluatorContext;
import io.imunity.scim.user.mapping.evaluation.MVELEvaluator;
import io.imunity.scim.user.mapping.evaluation.MappingEvaluator;
import io.imunity.scim.user.mapping.evaluation.MappingEvaluatorRegistry;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.exceptions.EngineException;

@Component
class ReferenceMappingEvaluator
implements MappingEvaluator {
    private static final Logger log = Log.getLogger((String)"unity.server.scim", ReferenceMappingEvaluator.class);
    private final MVELEvaluator mvelEvaluator;
    private final DataArrayResolver dataArrayResolver;

    ReferenceMappingEvaluator(MVELEvaluator mvelEvaluator, DataArrayResolver dataArrayResolver) {
        this.mvelEvaluator = mvelEvaluator;
        this.dataArrayResolver = dataArrayResolver;
    }

    @Override
    public String getId() {
        return "Reference";
    }

    @Override
    public EvaluationResult eval(AttributeDefinitionWithMapping attributeDefinitionWithMapping, EvaluatorContext context, MappingEvaluatorRegistry registry) throws EngineException {
        log.debug("Eval reference mapping for attribute {}", (Object)attributeDefinitionWithMapping.attributeDefinition.name);
        ReferenceAttributeMapping mapping = (ReferenceAttributeMapping)attributeDefinitionWithMapping.attributeMapping;
        return attributeDefinitionWithMapping.attributeDefinition.multiValued ? this.evalMulti(attributeDefinitionWithMapping, context, registry, mapping) : this.evalSingle(attributeDefinitionWithMapping, context, registry, mapping);
    }

    private EvaluationResult evalMulti(AttributeDefinitionWithMapping attributeDefinitionWithMapping, EvaluatorContext context, MappingEvaluatorRegistry registry, ReferenceAttributeMapping mapping) throws EngineException {
        if (attributeDefinitionWithMapping.attributeMapping.getDataArray().isEmpty()) {
            return EvaluationResult.builder().withAttributeName(attributeDefinitionWithMapping.attributeDefinition.name).build();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object arrayObj : this.dataArrayResolver.resolve(mapping.getDataArray().get(), context)) {
            ret.add(this.resolveReference(mapping.type, this.mvelEvaluator.evalMVEL(mapping.expression, EvaluatorContext.builder().withUser(context.user).withArrayObj(arrayObj).withScimEndpointDescription(context.scimEndpointDescription).withGroupProvider(context.groupProvider).build()), context));
        }
        return EvaluationResult.builder().withAttributeName(attributeDefinitionWithMapping.attributeDefinition.name).withValue(Optional.ofNullable(ret.isEmpty() ? null : ret)).build();
    }

    private EvaluationResult evalSingle(AttributeDefinitionWithMapping attributeDefinitionWithMapping, EvaluatorContext context, MappingEvaluatorRegistry registry, ReferenceAttributeMapping mapping) throws EngineException {
        return EvaluationResult.builder().withAttributeName(attributeDefinitionWithMapping.attributeDefinition.name).withValue(Optional.ofNullable(this.resolveReference(mapping.type, this.mvelEvaluator.evalMVEL(mapping.expression, context), context))).build();
    }

    private Object resolveReference(ReferenceAttributeMapping.ReferenceType type, Object value, EvaluatorContext context) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case GROUP: {
                return this.getGroupLocation(value.toString(), context);
            }
            case USER: {
                return this.getUserLocation(value.toString(), context);
            }
        }
        return UriBuilder.fromUri((String)value.toString()).build(new Object[0]);
    }

    private URI getGroupLocation(String group, EvaluatorContext context) {
        return UriBuilder.fromUri((URI)context.scimEndpointDescription.baseLocation).path("/Groups").path(URLEncoder.encode(group, StandardCharsets.UTF_8)).build(new Object[0]);
    }

    private URI getUserLocation(String user, EvaluatorContext context) {
        return UriBuilder.fromUri((URI)context.scimEndpointDescription.baseLocation).path("/Users").path(URLEncoder.encode(user, StandardCharsets.UTF_8)).build(new Object[0]);
    }
}

