/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user.mapping.evaluation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.imunity.scim.user.mapping.evaluation.EvaluatorContext;
import io.imunity.scim.user.mapping.evaluation.SCIMMvelContextKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mvel2.MVEL;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.engine.api.AttributeValueConverter;
import pl.edu.icm.unity.exceptions.IllegalAttributeValueException;
import pl.edu.icm.unity.types.basic.Attribute;
import pl.edu.icm.unity.types.basic.AttributeExt;
import pl.edu.icm.unity.types.basic.Identity;

@Component
class MVELEvaluator {
    public final int COMPILED_MVEL_CACHE_TTL_IN_HOURS = 1;
    private final AttributeValueConverter attrValueConverter;
    private final Cache<String, Serializable> compiledMvelCache;

    MVELEvaluator(AttributeValueConverter attrValueConverter) {
        this.attrValueConverter = attrValueConverter;
        this.compiledMvelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    }

    Object evalMVEL(String mvel, EvaluatorContext context) throws IllegalAttributeValueException {
        if (mvel == null) {
            return null;
        }
        Serializable expressionCompiled = this.getCompiledMvel(mvel);
        return MVEL.executeExpression((Object)expressionCompiled, (Object)this.createContext(context), new HashMap());
    }

    private Serializable getCompiledMvel(String mvel) {
        Serializable cached = (Serializable)this.compiledMvelCache.getIfPresent((Object)mvel);
        if (cached != null) {
            return cached;
        }
        Serializable actual = MVEL.compileExpression((String)mvel);
        this.compiledMvelCache.put((Object)mvel, (Object)actual);
        return actual;
    }

    Object createContext(EvaluatorContext context) throws IllegalAttributeValueException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(SCIMMvelContextKey.idsByType.toString(), this.createIdentityContextElement(context));
        this.addAttributesToContext(SCIMMvelContextKey.attr.name(), SCIMMvelContextKey.attrObj.name(), SCIMMvelContextKey.attrs.name(), ret, context.user.attributes, this.attrValueConverter);
        ArrayList groups = new ArrayList();
        HashMap groupsObj = new HashMap();
        context.user.groups.forEach(g -> {
            groups.add(g.getPathEncoded());
            groupsObj.put(g.getName(), context.groupProvider.get(g.getPathEncoded()));
        });
        ret.put(SCIMMvelContextKey.groups.toString(), groups);
        ret.put(SCIMMvelContextKey.groupsObj.name(), groupsObj);
        if (context.arrayObj != null) {
            ret.put(SCIMMvelContextKey.arrayObj.toString(), context.arrayObj);
        }
        return ret;
    }

    private void addAttributesToContext(String attrKey, String attrObjKey, String attrsKey, Map<String, Object> ret, List<AttributeExt> attributes, AttributeValueConverter attrConverter) throws IllegalAttributeValueException {
        HashMap<String, String> attr = new HashMap<String, String>();
        HashMap<String, Object> attrObj = new HashMap<String, Object>();
        HashMap<String, List> attrs = new HashMap<String, List>();
        for (Attribute attribute : attributes) {
            List values = attrConverter.internalValuesToExternal(attribute.getName(), attribute.getValues());
            String v = values.isEmpty() ? "" : (String)values.get(0);
            attr.put(attribute.getName(), v);
            attrs.put(attribute.getName(), values);
            attrObj.put(attribute.getName(), values.isEmpty() ? "" : attrConverter.internalValuesToObjectValues(attribute.getName(), attribute.getValues()));
        }
        ret.put(attrKey, attr);
        ret.put(attrObjKey, attrObj);
        ret.put(attrsKey, attrs);
    }

    private Map<String, List<String>> createIdentityContextElement(EvaluatorContext context) {
        HashMap<String, List<String>> idsByType = new HashMap<String, List<String>>();
        for (Identity id : context.user.identities) {
            ArrayList<String> vals = (ArrayList<String>)idsByType.get(id.getTypeId());
            if (vals == null) {
                vals = new ArrayList<String>();
                idsByType.put(id.getTypeId(), vals);
            }
            vals.add(id.getValue());
        }
        return idsByType;
    }
}

