/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user.mapping.evaluation;

import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.user.User;
import java.util.Objects;
import pl.edu.icm.unity.engine.api.mvel.CachingMVELGroupProvider;

class EvaluatorContext {
    final User user;
    final Object arrayObj;
    final CachingMVELGroupProvider groupProvider;
    final SCIMEndpointDescription scimEndpointDescription;

    private EvaluatorContext(Builder builder) {
        this.user = builder.user;
        this.arrayObj = builder.arrayObj;
        this.groupProvider = builder.groupProvider;
        this.scimEndpointDescription = builder.scimEndpointDescription;
    }

    public int hashCode() {
        return Objects.hash(this.arrayObj, this.groupProvider, this.scimEndpointDescription, this.user);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluatorContext other = (EvaluatorContext)obj;
        return Objects.equals(this.arrayObj, other.arrayObj) && Objects.equals(this.groupProvider, other.groupProvider) && Objects.equals(this.scimEndpointDescription, other.scimEndpointDescription) && Objects.equals(this.user, other.user);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private User user;
        private Object arrayObj;
        private CachingMVELGroupProvider groupProvider;
        private SCIMEndpointDescription scimEndpointDescription;

        private Builder() {
        }

        public Builder withUser(User user) {
            this.user = user;
            return this;
        }

        public Builder withArrayObj(Object arrayObj) {
            this.arrayObj = arrayObj;
            return this;
        }

        public Builder withGroupProvider(CachingMVELGroupProvider groupProvider) {
            this.groupProvider = groupProvider;
            return this;
        }

        public Builder withScimEndpointDescription(SCIMEndpointDescription scimEndpointDescription) {
            this.scimEndpointDescription = scimEndpointDescription;
            return this;
        }

        public EvaluatorContext build() {
            return new EvaluatorContext(this);
        }
    }
}

