/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user.mapping.evaluation;

import io.imunity.scim.config.AttributeDefinitionWithMapping;
import io.imunity.scim.user.mapping.evaluation.DataArrayResolver;
import io.imunity.scim.user.mapping.evaluation.EvaluationResult;
import io.imunity.scim.user.mapping.evaluation.EvaluatorContext;
import io.imunity.scim.user.mapping.evaluation.MappingEvaluator;
import io.imunity.scim.user.mapping.evaluation.MappingEvaluatorRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.exceptions.EngineException;

@Component
class ComplexMappingEvaluator
implements MappingEvaluator {
    private static final Logger log = Log.getLogger((String)"unity.server.scim", ComplexMappingEvaluator.class);
    private final DataArrayResolver dataArrayResolver;

    ComplexMappingEvaluator(DataArrayResolver dataArrayResolver) {
        this.dataArrayResolver = dataArrayResolver;
    }

    @Override
    public String getId() {
        return "Complex";
    }

    @Override
    public EvaluationResult eval(AttributeDefinitionWithMapping attributeDefinitionWithMapping, EvaluatorContext context, MappingEvaluatorRegistry mappingEvaluatorRegistry) throws EngineException {
        log.debug("Eval complex mapping for attribute {}", (Object)attributeDefinitionWithMapping.attributeDefinition.name);
        return attributeDefinitionWithMapping.attributeDefinition.multiValued ? this.evalMulti(attributeDefinitionWithMapping, context, mappingEvaluatorRegistry) : this.evalSingle(attributeDefinitionWithMapping, context, mappingEvaluatorRegistry);
    }

    private EvaluationResult evalMulti(AttributeDefinitionWithMapping attributeDefinitionWithMapping, EvaluatorContext context, MappingEvaluatorRegistry mappingEvaluatorRegistry) throws EngineException {
        ArrayList retArray = new ArrayList();
        if (attributeDefinitionWithMapping.attributeMapping.getDataArray().isEmpty()) {
            return EvaluationResult.builder().withAttributeName(attributeDefinitionWithMapping.attributeDefinition.name).build();
        }
        for (Object arrayObj : this.dataArrayResolver.resolve(attributeDefinitionWithMapping.attributeMapping.getDataArray().get(), context)) {
            HashMap<String, Object> subAtributeEvalRet = new HashMap<String, Object>();
            for (AttributeDefinitionWithMapping subAttr : attributeDefinitionWithMapping.attributeDefinition.subAttributesWithMapping) {
                EvaluationResult sResult = ((MappingEvaluator)mappingEvaluatorRegistry.getByName(subAttr.attributeMapping.getEvaluatorId())).eval(subAttr, EvaluatorContext.builder().withUser(context.user).withArrayObj(arrayObj).withScimEndpointDescription(context.scimEndpointDescription).withGroupProvider(context.groupProvider).build(), mappingEvaluatorRegistry);
                if (!sResult.value.isPresent()) continue;
                subAtributeEvalRet.put(sResult.attributeName, sResult.value.get());
            }
            retArray.add(subAtributeEvalRet);
        }
        return EvaluationResult.builder().withAttributeName(attributeDefinitionWithMapping.attributeDefinition.name).withValue(Optional.ofNullable(retArray.isEmpty() ? null : retArray)).build();
    }

    private EvaluationResult evalSingle(AttributeDefinitionWithMapping attributeDefinitionWithMapping, EvaluatorContext context, MappingEvaluatorRegistry mappingEvaluatorRegistry) throws EngineException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (AttributeDefinitionWithMapping subAttr : attributeDefinitionWithMapping.attributeDefinition.subAttributesWithMapping) {
            EvaluationResult sResult = ((MappingEvaluator)mappingEvaluatorRegistry.getByName(subAttr.attributeMapping.getEvaluatorId())).eval(subAttr, context, mappingEvaluatorRegistry);
            if (!sResult.value.isPresent()) continue;
            ret.put(sResult.attributeName, sResult.value.get());
        }
        return EvaluationResult.builder().withAttributeName(attributeDefinitionWithMapping.attributeDefinition.name).withValue(Optional.ofNullable(ret.isEmpty() ? null : ret)).build();
    }
}

