/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user;

import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.user.PersistentId;
import io.imunity.scim.user.User;
import io.imunity.scim.user.UserAuthzService;
import io.imunity.scim.user.UserNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.AttributesManagement;
import pl.edu.icm.unity.engine.api.EntityManagement;
import pl.edu.icm.unity.engine.api.authn.InvocationContext;
import pl.edu.icm.unity.engine.api.bulk.BulkGroupQueryService;
import pl.edu.icm.unity.engine.api.bulk.EntityInGroupData;
import pl.edu.icm.unity.engine.api.bulk.GroupMembershipData;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.types.basic.AttributeExt;
import pl.edu.icm.unity.types.basic.Entity;
import pl.edu.icm.unity.types.basic.EntityParam;
import pl.edu.icm.unity.types.basic.Group;
import pl.edu.icm.unity.types.basic.GroupContents;
import pl.edu.icm.unity.types.basic.IdentityTaV;

class UserRetrievalService {
    private static final Logger log = Log.getLogger((String)"unity.server.scim", UserRetrievalService.class);
    public static final String DEFAULT_META_VERSION = "v1";
    private final UserAuthzService authzService;
    private final EntityManagement entityManagement;
    private final BulkGroupQueryService bulkService;
    private final AttributesManagement attrMan;
    private final SCIMEndpointDescription configuration;

    UserRetrievalService(UserAuthzService scimAuthzService, EntityManagement entityManagement, BulkGroupQueryService bulkService, AttributesManagement attrMan, SCIMEndpointDescription configuration) {
        this.entityManagement = entityManagement;
        this.configuration = configuration;
        this.bulkService = bulkService;
        this.authzService = scimAuthzService;
        this.attrMan = attrMan;
    }

    User getLoggedUser() throws EngineException {
        Entity entity = this.entityManagement.getEntity(new EntityParam(Long.valueOf(InvocationContext.getCurrent().getLoginSession().getEntityId())));
        return this.getUser(entity);
    }

    User getUser(PersistentId userId) throws EngineException {
        Entity entity = this.entityManagement.getEntity(new EntityParam(new IdentityTaV("persistent", userId.id)));
        return this.getUser(entity);
    }

    private User getUser(Entity entity) throws EngineException {
        Map groups = this.entityManagement.getGroups(new EntityParam(entity.getId()));
        this.authzService.checkReadUser(entity.getId(), groups.keySet());
        if (!groups.keySet().contains(this.configuration.rootGroup)) {
            log.error("User " + entity.getId() + " is out of range for configured membership groups");
            throw new UserNotFoundException("Invalid user");
        }
        Set userGroups = groups.keySet().stream().filter(userGroup -> this.configuration.membershipGroups.stream().anyMatch(mgroup -> Group.isChildOrSame((String)userGroup, (String)mgroup))).collect(Collectors.toSet());
        Map<String, GroupContents> groupAndSubgroups = this.getAllMembershipGroups();
        Collection attributes = this.attrMan.getAttributes(new EntityParam(entity.getId()), this.configuration.rootGroup, null);
        return this.mapToUser(entity, groupAndSubgroups.entrySet().stream().filter(e -> userGroups.contains(e.getKey())).map(e -> ((GroupContents)e.getValue()).getGroup()).collect(Collectors.toSet()), attributes.stream().collect(Collectors.toMap(a -> a.getName(), a -> a)));
    }

    List<User> getUsers() throws EngineException {
        this.authzService.checkReadUsers();
        ArrayList<User> users = new ArrayList<User>();
        GroupMembershipData bulkMembershipData = this.bulkService.getBulkMembershipData("/");
        Map membershipInfo = this.bulkService.getMembershipInfo(bulkMembershipData);
        Map<String, GroupContents> groupAndSubgroups = this.getAllMembershipGroups();
        Map groupUsersAttributes = this.bulkService.getGroupUsersAttributes(this.configuration.rootGroup, bulkMembershipData);
        for (EntityInGroupData entityInGroup : membershipInfo.values()) {
            if (!entityInGroup.groups.contains(this.configuration.rootGroup)) continue;
            HashSet groups = new HashSet(entityInGroup.groups);
            groups.retainAll(groupAndSubgroups.keySet());
            users.add(this.mapToUser(entityInGroup.entity, groupAndSubgroups.entrySet().stream().filter(e -> groups.contains(e.getKey())).map(e -> ((GroupContents)e.getValue()).getGroup()).collect(Collectors.toSet()), groupUsersAttributes.getOrDefault(entityInGroup.entity.getId(), Collections.emptyMap())));
        }
        return users;
    }

    private Map<String, GroupContents> getAllMembershipGroups() throws EngineException {
        Map groupAndSubgroups = this.bulkService.getGroupAndSubgroups(this.bulkService.getBulkStructuralData("/"));
        HashMap<String, GroupContents> ret = new HashMap<String, GroupContents>();
        for (String g : this.configuration.membershipGroups) {
            for (String ag : groupAndSubgroups.keySet()) {
                if (!Group.isChildOrSame((String)ag, (String)g)) continue;
                ret.put(ag, (GroupContents)groupAndSubgroups.get(ag));
            }
        }
        return ret;
    }

    private User mapToUser(Entity entity, Set<Group> groups, Map<String, AttributeExt> attributes) {
        return User.builder().withEntityId(entity.getId()).withGroups(groups).withIdentities(entity.getIdentities()).withAttributes(attributes.values().stream().collect(Collectors.toList())).build();
    }

    @Component
    static class SCIMUserRetrievalServiceFactory {
        private final EntityManagement entityManagement;
        private final BulkGroupQueryService bulkService;
        private final UserAuthzService.SCIMUserAuthzServiceFactory authzManFactory;
        private final AttributesManagement attrMan;

        @Autowired
        SCIMUserRetrievalServiceFactory(@Qualifier(value="insecure") EntityManagement entityManagement, @Qualifier(value="insecure") BulkGroupQueryService bulkService, @Qualifier(value="insecure") AttributesManagement attrMan, UserAuthzService.SCIMUserAuthzServiceFactory authzManFactory) {
            this.entityManagement = entityManagement;
            this.bulkService = bulkService;
            this.authzManFactory = authzManFactory;
            this.attrMan = attrMan;
        }

        UserRetrievalService getService(SCIMEndpointDescription configuration) {
            return new UserRetrievalService(this.authzManFactory.getService(configuration), this.entityManagement, this.bulkService, this.attrMan, configuration);
        }
    }
}

