/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imunity.scim.SCIMConstants;
import io.imunity.scim.SCIMRestController;
import io.imunity.scim.SCIMRestControllerFactory;
import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.user.PersistentId;
import io.imunity.scim.user.UserAssemblyService;
import io.imunity.scim.user.UserRetrievalService;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.exceptions.EngineException;

@Produces(value={"application/json"})
@Path(value="")
public class UserRestController
implements SCIMRestController {
    public static final String USER_LOCATION = "/Users";
    private static final Logger log = Log.getLogger((String)"unity.server.scim", UserRestController.class);
    private final UserRetrievalService userService;
    private final UserAssemblyService userMapperService;
    private final ObjectMapper mapper = SCIMConstants.MAPPER;

    UserRestController(UserRetrievalService userService, UserAssemblyService userMapperService) {
        this.userService = userService;
        this.userMapperService = userMapperService;
    }

    @Path(value="/Me")
    @GET
    public Response getUser(@Context UriInfo uriInfo) throws EngineException, JsonProcessingException {
        log.debug("Get logged user");
        return Response.ok().entity((Object)this.mapper.writeValueAsString((Object)this.userMapperService.mapToUserResource(this.userService.getLoggedUser()))).contentLocation(uriInfo.getRequestUri()).build();
    }

    @Path(value="/Users")
    @GET
    public Response getUsers(@Context UriInfo uriInfo) throws EngineException, JsonProcessingException {
        log.debug("Get users");
        return Response.ok().entity((Object)this.mapper.writeValueAsString(this.userMapperService.mapToListUsersResource(this.userService.getUsers()))).contentLocation(uriInfo.getRequestUri()).build();
    }

    @Path(value="/Users/{id}")
    @GET
    public String getUser(@PathParam(value="id") String userId) throws EngineException, JsonProcessingException {
        log.debug("Get user with id: {}", (Object)userId);
        return this.mapper.writeValueAsString((Object)this.userMapperService.mapToUserResource(this.userService.getUser(new PersistentId(userId))));
    }

    @Component
    static class SCIMUserRestControllerFactory
    implements SCIMRestControllerFactory {
        private final UserRetrievalService.SCIMUserRetrievalServiceFactory retServiceFactory;
        private final UserAssemblyService.SCIMUserAssemblyServiceFactory assemblyServiceFactory;

        @Autowired
        SCIMUserRestControllerFactory(UserRetrievalService.SCIMUserRetrievalServiceFactory retServiceFactory, UserAssemblyService.SCIMUserAssemblyServiceFactory assemblyServiceFactory) {
            this.retServiceFactory = retServiceFactory;
            this.assemblyServiceFactory = assemblyServiceFactory;
        }

        @Override
        public SCIMRestController getController(SCIMEndpointDescription configuration) {
            return new UserRestController(this.retServiceFactory.getService(configuration), this.assemblyServiceFactory.getService(configuration));
        }
    }
}

