/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user;

import java.time.Instant;
import java.util.Objects;

class UserIdentity {
    final Instant creationTs;
    final Instant updateTs;
    final String typeId;
    final String value;

    private UserIdentity(Builder builder) {
        this.creationTs = builder.creationTs;
        this.updateTs = builder.updateTs;
        this.typeId = builder.typeId;
        this.value = builder.value;
    }

    public int hashCode() {
        return Objects.hash(this.creationTs, this.typeId, this.updateTs, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserIdentity other = (UserIdentity)obj;
        return Objects.equals(this.creationTs, other.creationTs) && Objects.equals(this.typeId, other.typeId) && Objects.equals(this.updateTs, other.updateTs) && Objects.equals(this.value, other.value);
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private Instant creationTs;
        private Instant updateTs;
        private String typeId;
        private String value;

        private Builder() {
        }

        Builder withCreationTs(Instant creationTs) {
            this.creationTs = creationTs;
            return this;
        }

        Builder withUpdateTs(Instant updateTs) {
            this.updateTs = updateTs;
            return this;
        }

        Builder withTypeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        Builder withValue(String value) {
            this.value = value;
            return this;
        }

        UserIdentity build() {
            return new UserIdentity(this);
        }
    }
}

