/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user;

import java.util.Objects;

class UserGroup {
    final String value;
    final String displayName;
    final GroupType type;

    private UserGroup(Builder builder) {
        this.value = builder.value;
        this.displayName = builder.displayName;
        this.type = builder.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.displayName, this.type, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserGroup other = (UserGroup)obj;
        return Objects.equals(this.displayName, other.displayName) && this.type == other.type && Objects.equals(this.value, other.value);
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String value;
        private String displayName;
        private GroupType type;

        private Builder() {
        }

        Builder withValue(String value) {
            this.value = value;
            return this;
        }

        Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        Builder withType(GroupType type) {
            this.type = type;
            return this;
        }

        UserGroup build() {
            return new UserGroup(this);
        }
    }

    static enum GroupType {
        direct,
        indirect;

    }
}

