/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user;

import io.imunity.scim.SCIMSystemScopeProvider;
import io.imunity.scim.config.AttributeDefinitionWithMapping;
import io.imunity.scim.config.SCIMEndpointDescription;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.AuthorizationManagement;
import pl.edu.icm.unity.engine.api.authn.InvocationContext;
import pl.edu.icm.unity.exceptions.AuthorizationException;

class UserAuthzService {
    private static final Logger log = Log.getLogger((String)"unity.server.scim", UserAuthzService.class);
    private final AuthorizationManagement authzMan;
    private final SCIMEndpointDescription configuration;

    UserAuthzService(AuthorizationManagement authzMan, SCIMEndpointDescription configuration) {
        this.authzMan = authzMan;
        this.configuration = configuration;
    }

    void checkReadUser(long entity, Set<String> userGroups) throws AuthorizationException {
        InvocationContext invocationContext = InvocationContext.getCurrent();
        switch (invocationContext.getInvocationMaterial()) {
            case DIRECT: {
                this.checkReadUserWithDirectInvocationMaterial(entity, invocationContext, userGroups);
                break;
            }
            case OAUTH_DELEGATION: {
                this.checkReadUserWithOAuthInvocationMaterial(entity, invocationContext, userGroups);
                break;
            }
            default: {
                throw new AuthorizationException("Access is denied");
            }
        }
    }

    private void checkReadUserWithDirectInvocationMaterial(long entity, InvocationContext invocationContext, Set<String> userGroups) throws AuthorizationException {
        long callerId = invocationContext.getLoginSession().getEntityId();
        try {
            this.authzMan.checkReadCapability(entity == callerId, this.configuration.rootGroup);
        }
        catch (AuthorizationException e) {
            if (entity == callerId && userGroups.contains(this.configuration.rootGroup)) {
                return;
            }
            log.debug("Access is denied. Caller not a member of root SCIM group");
            throw new AuthorizationException("Access is denied");
        }
    }

    private void checkReadUserWithOAuthInvocationMaterial(long entity, InvocationContext invocationContext, Set<String> userGroups) throws AuthorizationException {
        long callerId = invocationContext.getLoginSession().getEntityId();
        if (entity != callerId) {
            log.debug("Access is denied. Caller wants to read data that is not his own");
            throw new AuthorizationException("Access is denied");
        }
        if (!userGroups.contains(this.configuration.rootGroup)) {
            log.debug("Access is denied. Caller not a member of root SCIM group");
            throw new AuthorizationException("Access is denied");
        }
        if (!invocationContext.getScopes().stream().anyMatch(SCIMSystemScopeProvider.getScopeNames()::contains)) {
            log.debug("Access is denied. Client does not have the required scopes");
            throw new AuthorizationException("Access is denied");
        }
    }

    void checkReadUsers() throws AuthorizationException {
        if (!InvocationContext.getCurrent().getInvocationMaterial().equals((Object)InvocationContext.InvocationMaterial.DIRECT)) {
            log.debug("Access is denied. Reading users is available only via direct access");
            throw new AuthorizationException("Access is denied");
        }
        this.authzMan.checkReadCapability(false, this.configuration.rootGroup);
    }

    Predicate<AttributeDefinitionWithMapping> getFilter() {
        InvocationContext current = InvocationContext.getCurrent();
        if (current.getInvocationMaterial().equals((Object)InvocationContext.InvocationMaterial.DIRECT)) {
            return s -> true;
        }
        Predicate<AttributeDefinitionWithMapping> attributeFilter = s -> false;
        if (current.getScopes().contains("sys:scim:read_profile")) {
            attributeFilter = attributeFilter.or(s -> !this.configuration.membershipAttributes.contains(s.attributeDefinition.name));
        }
        if (current.getScopes().contains("sys:scim:read_memberships")) {
            attributeFilter = attributeFilter.or(s -> this.configuration.membershipAttributes.contains(s.attributeDefinition.name));
        }
        return attributeFilter;
    }

    @Component
    static class SCIMUserAuthzServiceFactory {
        private final AuthorizationManagement authzMan;

        @Autowired
        SCIMUserAuthzServiceFactory(AuthorizationManagement authzMan) {
            this.authzMan = authzMan;
        }

        UserAuthzService getService(SCIMEndpointDescription configuration) {
            return new UserAuthzService(this.authzMan, configuration);
        }
    }
}

