/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

class UserAttribute {
    final String name;
    final List<String> values;

    private UserAttribute(Builder builder) {
        this.name = builder.name;
        this.values = List.copyOf(builder.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAttribute other = (UserAttribute)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.values, other.values);
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String name;
        private List<String> values = Collections.emptyList();

        private Builder() {
        }

        Builder withName(String name) {
            this.name = name;
            return this;
        }

        Builder withValues(List<String> values) {
            this.values = values;
            return this;
        }

        UserAttribute build() {
            return new UserAttribute(this);
        }
    }
}

