/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user;

import eu.unicore.util.configuration.ConfigurationException;
import io.imunity.scim.common.ListResponse;
import io.imunity.scim.common.Meta;
import io.imunity.scim.common.ResourceType;
import io.imunity.scim.config.AttributeDefinitionWithMapping;
import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.config.SchemaType;
import io.imunity.scim.config.SchemaWithMapping;
import io.imunity.scim.user.SCIMUserResource;
import io.imunity.scim.user.SchemaFilteringSupport;
import io.imunity.scim.user.User;
import io.imunity.scim.user.UserAuthzService;
import io.imunity.scim.user.mapping.evaluation.UserSchemaEvaluator;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.engine.api.GroupsManagement;
import pl.edu.icm.unity.engine.api.mvel.CachingMVELGroupProvider;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.types.basic.Identity;

class UserAssemblyService {
    private final SCIMEndpointDescription configuration;
    private final UserSchemaEvaluator userSchemaEvaluator;
    private final GroupsManagement groupsManagement;
    private final UserAuthzService authzService;

    UserAssemblyService(SCIMEndpointDescription configuration, UserSchemaEvaluator userSchemaEvaluator, GroupsManagement groupsManagement, UserAuthzService authzService) {
        this.configuration = configuration;
        this.userSchemaEvaluator = userSchemaEvaluator;
        this.groupsManagement = groupsManagement;
        this.authzService = authzService;
    }

    SCIMUserResource mapToUserResource(User user) throws EngineException {
        Predicate<AttributeDefinitionWithMapping> filter = this.authzService.getFilter();
        List<SchemaWithMapping> schemas = this.getFilteredSchemas(filter);
        return this.mapToSingleUserResource(user, schemas, new CachingMVELGroupProvider(this.groupsManagement.getAllGroups()));
    }

    ListResponse<SCIMUserResource> mapToListUsersResource(List<User> users) throws EngineException {
        ArrayList<SCIMUserResource> usersResource = new ArrayList<SCIMUserResource>();
        Predicate<AttributeDefinitionWithMapping> filter = this.authzService.getFilter();
        List<SchemaWithMapping> schemas = this.getFilteredSchemas(filter);
        CachingMVELGroupProvider groupProvider = new CachingMVELGroupProvider(this.groupsManagement.getAllGroups());
        for (User u : users) {
            usersResource.add(this.mapToSingleUserResource(u, schemas, groupProvider));
        }
        return ListResponse.builder().withResources(usersResource).withTotalResults(usersResource.size()).build();
    }

    private SCIMUserResource mapToSingleUserResource(User user, List<SchemaWithMapping> schemas, CachingMVELGroupProvider cachingMVELGroupProvider) throws EngineException {
        Identity persistenceIdentity = user.identities.stream().filter(i -> i.getTypeId().equals("persistent")).findFirst().get();
        Instant lastModified = user.identities.stream().map(i -> i.getUpdateTs().toInstant()).sorted(Comparator.reverseOrder()).findFirst().get();
        URI location = UriBuilder.fromUri((URI)this.configuration.baseLocation).path("/Users/" + persistenceIdentity.getValue()).build(new Object[0]);
        return ((SCIMUserResource.Builder)((SCIMUserResource.Builder)((SCIMUserResource.Builder)SCIMUserResource.builder().withId(persistenceIdentity.getValue())).withSchemas(schemas.stream().map(s -> s.id).collect(Collectors.toSet()))).withMeta(Meta.builder().withResourceType(ResourceType.USER.getName()).withCreated(persistenceIdentity.getCreationTs().toInstant()).withLastModified(lastModified).withLocation(location).build())).withAttributes(this.userSchemaEvaluator.evalUserSchema(user, schemas, cachingMVELGroupProvider)).build();
    }

    private List<SchemaWithMapping> getFilteredSchemas(Predicate<AttributeDefinitionWithMapping> filter) {
        List<SchemaWithMapping> schemas = this.configuration.schemas.stream().filter(s -> (s.type.equals((Object)SchemaType.USER) || s.type.equals((Object)SchemaType.USER_CORE)) && s.enable).map(s -> SchemaFilteringSupport.getSchemaWithFilteredAttributes(s, filter)).collect(Collectors.toList());
        if (schemas.isEmpty()) {
            throw new ConfigurationException("No user schemas are active");
        }
        return schemas;
    }

    @Component
    static class SCIMUserAssemblyServiceFactory {
        private final UserSchemaEvaluator.UserSchemaEvaluatorFactory userSchemaEvaluator;
        private final GroupsManagement groupsManagement;
        private final UserAuthzService.SCIMUserAuthzServiceFactory authzManFactory;

        public SCIMUserAssemblyServiceFactory(UserSchemaEvaluator.UserSchemaEvaluatorFactory userSchemaEvaluator, @Qualifier(value="insecure") GroupsManagement groupsManagement, UserAuthzService.SCIMUserAuthzServiceFactory authzManFactory) {
            this.userSchemaEvaluator = userSchemaEvaluator;
            this.groupsManagement = groupsManagement;
            this.authzManFactory = authzManFactory;
        }

        UserAssemblyService getService(SCIMEndpointDescription configuration) {
            return new UserAssemblyService(configuration, this.userSchemaEvaluator.getService(configuration), this.groupsManagement, this.authzManFactory.getService(configuration));
        }
    }
}

