/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import pl.edu.icm.unity.types.basic.AttributeExt;
import pl.edu.icm.unity.types.basic.Group;
import pl.edu.icm.unity.types.basic.Identity;

public class User {
    final Long entityId;
    public final List<Identity> identities;
    public final Set<Group> groups;
    public final List<AttributeExt> attributes;

    private User(Builder builder) {
        this.entityId = builder.entityId;
        this.identities = List.copyOf(builder.identities);
        this.groups = Set.copyOf(builder.groups);
        this.attributes = List.copyOf(builder.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.entityId, this.groups, this.identities);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.entityId, other.entityId) && Objects.equals(this.groups, other.groups) && Objects.equals(this.identities, other.identities);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long entityId;
        private List<Identity> identities = Collections.emptyList();
        private Set<Group> groups = Collections.emptySet();
        private List<AttributeExt> attributes = Collections.emptyList();

        private Builder() {
        }

        public Builder withEntityId(Long entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder withIdentities(List<Identity> identities) {
            this.identities = identities;
            return this;
        }

        public Builder withGroups(Set<Group> groups) {
            this.groups = groups;
            return this;
        }

        public Builder withAttributes(List<AttributeExt> attributes) {
            this.attributes = attributes;
            return this;
        }

        public User build() {
            return new User(this);
        }
    }
}

