/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.user;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
class SCIMUserGroupResource {
    public final String value;
    @JsonProperty(value="$ref")
    public final URI ref;
    public final String display;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final String type;

    private SCIMUserGroupResource(Builder builder) {
        this.value = builder.value;
        this.ref = builder.ref;
        this.display = builder.display;
        this.type = builder.type;
    }

    public int hashCode() {
        return Objects.hash(this.display, this.ref, this.type, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SCIMUserGroupResource other = (SCIMUserGroupResource)obj;
        return Objects.equals(this.display, other.display) && Objects.equals(this.ref, other.ref) && this.type == other.type && Objects.equals(this.value, other.value);
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String value;
        private URI ref;
        private String display;
        private String type;

        private Builder() {
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withRef(URI ref) {
            this.ref = ref;
            return this;
        }

        public Builder withDisplay(String display) {
            this.display = display;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public SCIMUserGroupResource build() {
            return new SCIMUserGroupResource(this);
        }
    }
}

