/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imunity.scim.SCIMConstants;
import io.imunity.scim.SCIMRestController;
import io.imunity.scim.SCIMRestControllerFactory;
import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.schema.SCIMSchemaResource;
import io.imunity.scim.schema.SchemaAssemblyService;
import io.imunity.scim.schema.SchemaId;
import io.imunity.scim.schema.SchemaNotFoundException;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.exceptions.EngineException;

@Produces(value={"application/json"})
@Path(value="")
public class SchemaRestController
implements SCIMRestController {
    static final String SCHEMA_LOCATION = "/Schemas";
    private static final Logger log = Log.getLogger((String)"unity.server.scim", SchemaRestController.class);
    private final ObjectMapper mapper = SCIMConstants.MAPPER;
    private final SchemaAssemblyService schemaAssemblyService;

    SchemaRestController(SchemaAssemblyService schemaAssemblyService) {
        this.schemaAssemblyService = schemaAssemblyService;
    }

    @Path(value="/Schemas")
    @GET
    public Response getSchemas(@Context UriInfo uriInfo) throws EngineException, JsonProcessingException {
        log.debug("Get schemas");
        return Response.ok().entity((Object)this.mapper.writeValueAsString(this.schemaAssemblyService.getSchemasResource())).contentLocation(uriInfo.getRequestUri()).build();
    }

    @Path(value="/Schemas/{id}")
    @GET
    public Response getSchema(@PathParam(value="id") String schemaId, @Context UriInfo uriInfo) throws EngineException, JsonProcessingException {
        log.debug("Get schema with id: {}", (Object)schemaId);
        Optional<SCIMSchemaResource> schemaResource = this.schemaAssemblyService.getSchemaResource(new SchemaId(schemaId));
        if (schemaResource.isEmpty()) {
            throw new SchemaNotFoundException("Invalid schema " + schemaId);
        }
        return Response.ok().entity((Object)this.mapper.writeValueAsString((Object)schemaResource.get())).contentLocation(uriInfo.getRequestUri()).build();
    }

    @Component
    static class SCIMSchemaRestControllerFactory
    implements SCIMRestControllerFactory {
        private final SchemaAssemblyService.SCIMSchemaAssemblyServiceFactory assemblyServiceFactory;

        @Autowired
        SCIMSchemaRestControllerFactory(SchemaAssemblyService.SCIMSchemaAssemblyServiceFactory assemblyServiceFactory) {
            this.assemblyServiceFactory = assemblyServiceFactory;
        }

        @Override
        public SchemaRestController getController(SCIMEndpointDescription configuration) {
            return new SchemaRestController(this.assemblyServiceFactory.getService(configuration));
        }
    }
}

