/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.schema;

import io.imunity.scim.common.ListResponse;
import io.imunity.scim.common.Meta;
import io.imunity.scim.common.ResourceType;
import io.imunity.scim.config.AttributeDefinition;
import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.config.SchemaWithMapping;
import io.imunity.scim.schema.SCIMAttributeDefinitionResource;
import io.imunity.scim.schema.SCIMAttributeMutability;
import io.imunity.scim.schema.SCIMAttributeReturned;
import io.imunity.scim.schema.SCIMAttributeUniqueness;
import io.imunity.scim.schema.SCIMSchemaResource;
import io.imunity.scim.schema.SchemaId;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.springframework.stereotype.Component;

class SchemaAssemblyService {
    private final SCIMEndpointDescription configuration;

    SchemaAssemblyService(SCIMEndpointDescription configuration) {
        this.configuration = configuration;
    }

    Optional<SCIMSchemaResource> getSchemaResource(SchemaId schemaId) {
        Optional<SchemaWithMapping> schema = this.configuration.schemas.stream().filter(s -> s.id.equals(schemaId.id)).findAny();
        if (schema.isEmpty() || !schema.get().enable) {
            return Optional.empty();
        }
        return Optional.of(this.mapSingleSchemaResource(schema.get()));
    }

    ListResponse<SCIMSchemaResource> getSchemasResource() {
        List schemasResource = this.configuration.schemas.stream().filter(s -> s.enable).map(s -> this.mapSingleSchemaResource((SchemaWithMapping)s)).collect(Collectors.toList());
        return ListResponse.builder().withResources(schemasResource).withTotalResults(schemasResource.size()).build();
    }

    private SCIMSchemaResource mapSingleSchemaResource(SchemaWithMapping schema) {
        return ((SCIMSchemaResource.Builder)((SCIMSchemaResource.Builder)SCIMSchemaResource.builder().withName(schema.name).withDescription(schema.description).withId(schema.id)).withMeta(Meta.builder().withResourceType(ResourceType.SCHEMA.getName()).withLocation(this.getSchemaLocation(schema.id)).build())).withAttributes(schema.attributesWithMapping.stream().map(a -> this.mapSingleAttribute(a.attributeDefinition)).collect(Collectors.toList())).build();
    }

    private SCIMAttributeDefinitionResource mapSingleAttribute(AttributeDefinition a) {
        return SCIMAttributeDefinitionResource.builder().withName(a.name).withDescription(a.description).withType(a.type.getName()).withMultiValued(a.multiValued).withCaseExact(true).withRequired(false).withMutability(SCIMAttributeMutability.IMMUTABLE.getName()).withReturned(SCIMAttributeReturned.DEFAULT.getName()).withUniqueness(SCIMAttributeUniqueness.NONE.getName()).withSubAttributes(a.subAttributesWithMapping.stream().map(attr -> this.mapSingleAttribute(attr.attributeDefinition)).collect(Collectors.toList())).build();
    }

    private URI getSchemaLocation(String schema) {
        return UriBuilder.fromUri((URI)this.configuration.baseLocation).path("/Schemas").path(URLEncoder.encode(schema, StandardCharsets.UTF_8)).build(new Object[0]);
    }

    @Component
    static class SCIMSchemaAssemblyServiceFactory {
        SCIMSchemaAssemblyServiceFactory() {
        }

        SchemaAssemblyService getService(SCIMEndpointDescription configuration) {
            return new SchemaAssemblyService(configuration);
        }
    }
}

