/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.schema;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.imunity.scim.common.BasicSCIMResource;
import io.imunity.scim.schema.SCIMAttributeDefinitionResource;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
class SCIMSchemaResource
extends BasicSCIMResource {
    public final String name;
    public final String description;
    public final List<SCIMAttributeDefinitionResource> attributes;

    private SCIMSchemaResource(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.attributes = List.copyOf(builder.attributes);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.attributes, this.description, this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SCIMSchemaResource other = (SCIMSchemaResource)obj;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.description, other.description) && Objects.equals(this.name, other.name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BasicSCIMResource.BasicScimResourceBuilder<Builder> {
        private String name;
        private String description;
        private List<SCIMAttributeDefinitionResource> attributes = Collections.emptyList();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withAttributes(List<SCIMAttributeDefinitionResource> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public SCIMSchemaResource build() {
            return new SCIMSchemaResource(this);
        }
    }
}

