/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.schema;

import io.imunity.scim.schema.UnsupportedAttributeTypeException;
import java.util.Optional;
import java.util.stream.Stream;

public enum SCIMAttributeType {
    STRING("string"),
    BOOLEAN("boolean"),
    DATETIME("dateTime"),
    REFERENCE("reference"),
    COMPLEX("complex");

    private String name;

    private SCIMAttributeType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SCIMAttributeType fromName(String type) {
        Optional<SCIMAttributeType> atype = Stream.of(SCIMAttributeType.values()).filter(t -> t.name.equals(type)).findAny();
        if (atype.isEmpty()) {
            throw new UnsupportedAttributeTypeException("Attribute type " + type + " is unsupported");
        }
        return atype.get();
    }
}

