/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.schema;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
class SCIMAttributeDefinitionResource {
    public final String name;
    public final String type;
    public final String description;
    public final List<SCIMAttributeDefinitionResource> subAttributes;
    public final boolean required;
    public final List<String> canonicalValues;
    public final String mutability;
    public final boolean multiValued;
    public final boolean caseExact;
    public final String uniqueness;
    public final String returned;
    public final List<String> referenceTypes;

    private SCIMAttributeDefinitionResource(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.subAttributes = List.copyOf(builder.subAttributes);
        this.required = builder.required;
        this.canonicalValues = List.copyOf(builder.canonicalValues);
        this.mutability = builder.mutability;
        this.multiValued = builder.multiValued;
        this.caseExact = builder.caseExact;
        this.uniqueness = builder.uniqueness;
        this.returned = builder.returned;
        this.referenceTypes = List.copyOf(builder.referenceTypes);
    }

    public int hashCode() {
        return Objects.hash(this.canonicalValues, this.caseExact, this.description, this.multiValued, this.mutability, this.name, this.referenceTypes, this.required, this.returned, this.subAttributes, this.type, this.uniqueness);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SCIMAttributeDefinitionResource other = (SCIMAttributeDefinitionResource)obj;
        return Objects.equals(this.canonicalValues, other.canonicalValues) && this.caseExact == other.caseExact && Objects.equals(this.description, other.description) && this.multiValued == other.multiValued && Objects.equals(this.mutability, other.mutability) && Objects.equals(this.name, other.name) && Objects.equals(this.referenceTypes, other.referenceTypes) && this.required == other.required && Objects.equals(this.returned, other.returned) && Objects.equals(this.subAttributes, other.subAttributes) && Objects.equals(this.type, other.type) && Objects.equals(this.uniqueness, other.uniqueness);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private String name;
        private String type;
        private String description;
        private Collection<SCIMAttributeDefinitionResource> subAttributes = Collections.emptyList();
        private boolean required;
        private Collection<String> canonicalValues = Collections.emptyList();
        private String mutability;
        private boolean multiValued;
        private boolean caseExact;
        private String uniqueness;
        private String returned;
        private Collection<String> referenceTypes = Collections.emptyList();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withSubAttributes(Collection<SCIMAttributeDefinitionResource> subAttributes) {
            this.subAttributes = subAttributes;
            return this;
        }

        public Builder withRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder withCanonicalValues(Collection<String> canonicalValues) {
            this.canonicalValues = canonicalValues;
            return this;
        }

        public Builder withMutability(String mutability) {
            this.mutability = mutability;
            return this;
        }

        public Builder withMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
            return this;
        }

        public Builder withCaseExact(boolean caseExact) {
            this.caseExact = caseExact;
            return this;
        }

        public Builder withUniqueness(String uniqueness) {
            this.uniqueness = uniqueness;
            return this;
        }

        public Builder withReturned(String returned) {
            this.returned = returned;
            return this;
        }

        public Builder withReferenceTypes(Collection<String> referenceTypes) {
            this.referenceTypes = referenceTypes;
            return this;
        }

        public SCIMAttributeDefinitionResource build() {
            return new SCIMAttributeDefinitionResource(this);
        }
    }
}

