/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.group;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.imunity.scim.common.BasicSCIMResource;
import io.imunity.scim.group.SCIMGroupMemberResource;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
class SCIMGroupResource
extends BasicSCIMResource {
    static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:Group";
    public final String displayName;
    public final List<SCIMGroupMemberResource> members;

    private SCIMGroupResource(Builder builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.members = List.copyOf(builder.members);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.displayName, this.members);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SCIMGroupResource other = (SCIMGroupResource)obj;
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.members, other.members);
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder
    extends BasicSCIMResource.BasicScimResourceBuilder<Builder> {
        private String displayName;
        private List<SCIMGroupMemberResource> members = Collections.emptyList();

        private Builder() {
            this.withSchemas(Set.of(SCIMGroupResource.SCHEMA));
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withMembers(List<SCIMGroupMemberResource> members) {
            this.members = members;
            return this;
        }

        @Override
        public SCIMGroupResource build() {
            return new SCIMGroupResource(this);
        }
    }
}

