/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.group;

import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.group.GroupAuthzService;
import io.imunity.scim.group.GroupData;
import io.imunity.scim.group.GroupId;
import io.imunity.scim.group.GroupMember;
import io.imunity.scim.group.GroupNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.GroupsManagement;
import pl.edu.icm.unity.engine.api.attributes.AttributeSupport;
import pl.edu.icm.unity.engine.api.bulk.BulkGroupQueryService;
import pl.edu.icm.unity.engine.api.bulk.EntityInGroupData;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.types.basic.AttributeExt;
import pl.edu.icm.unity.types.basic.AttributeType;
import pl.edu.icm.unity.types.basic.Group;
import pl.edu.icm.unity.types.basic.GroupContents;
import pl.edu.icm.unity.types.basic.Identity;

class GroupRetrievalService {
    static final String DEFAULT_META_VERSION = "v1";
    private static final Logger log = Log.getLogger((String)"unity.server.scim", GroupRetrievalService.class);
    private final GroupAuthzService authzMan;
    private final MessageSource msg;
    private final GroupsManagement groupsMan;
    private final BulkGroupQueryService bulkService;
    private final AttributeSupport attrSupport;
    private final SCIMEndpointDescription configuration;

    GroupRetrievalService(MessageSource msg, GroupAuthzService authzMan, GroupsManagement groupMan, BulkGroupQueryService bulkService, AttributeSupport attrSupport, SCIMEndpointDescription configuration) {
        this.msg = msg;
        this.authzMan = authzMan;
        this.groupsMan = groupMan;
        this.bulkService = bulkService;
        this.configuration = configuration;
        this.attrSupport = attrSupport;
    }

    GroupData getGroup(GroupId groupId) throws EngineException {
        this.authzMan.checkReadGroups();
        this.assertIsMembershipGroup(groupId.id);
        Map membershipInfo = this.bulkService.getMembershipInfo(this.bulkService.getBulkMembershipData(groupId.id));
        Map attributesInfo = this.bulkService.getMembershipInfo(this.bulkService.getBulkMembershipData(this.configuration.rootGroup));
        Map groupAndSubgroups = this.bulkService.getGroupAndSubgroups(this.bulkService.getBulkStructuralData(groupId.id));
        GroupContents main = (GroupContents)groupAndSubgroups.get(groupId.id);
        Optional<String> nameAttribute = this.getNameAttribute();
        ArrayList<GroupMember> members = new ArrayList<GroupMember>();
        membershipInfo.values().forEach(m -> members.add(this.mapToUserMember((EntityInGroupData)m, Optional.ofNullable((EntityInGroupData)attributesInfo.get(m.entity.getId())), nameAttribute)));
        groupAndSubgroups.values().stream().filter(g -> !g.equals(main)).forEach(g -> members.add(this.mapToGroupMemeber((GroupContents)g)));
        return GroupData.builder().withDisplayName(main.getGroup().getDisplayedNameShort(this.msg).getValue(this.msg)).withId(main.getGroup().getPathEncoded()).withMembers(members).build();
    }

    private Optional<String> getNameAttribute() throws EngineException {
        AttributeType attributeTypeWithSingeltonMetadata = this.attrSupport.getAttributeTypeWithSingeltonMetadata("entityDisplayedName");
        return Optional.ofNullable(attributeTypeWithSingeltonMetadata != null ? attributeTypeWithSingeltonMetadata.getName() : null);
    }

    List<GroupData> getGroups() throws EngineException {
        this.authzMan.checkReadGroups();
        ArrayList<GroupData> groups = new ArrayList<GroupData>();
        Map membershipInfo = this.bulkService.getMembershipInfo(this.bulkService.getBulkMembershipData("/"));
        Optional<String> nameAttribute = this.getNameAttribute();
        Map attributesInfo = this.bulkService.getMembershipInfo(this.bulkService.getBulkMembershipData(this.configuration.rootGroup));
        for (String configuredMemebershipGroup : this.configuration.membershipGroups) {
            Map groupAndSubgroups = this.bulkService.getGroupAndSubgroups(this.bulkService.getBulkStructuralData(configuredMemebershipGroup));
            GroupContents main = (GroupContents)groupAndSubgroups.get(configuredMemebershipGroup);
            if (main == null) {
                log.warn("Can not get configured membership group " + configuredMemebershipGroup);
                continue;
            }
            this.fillMembersAndAddGroupResource(main, nameAttribute, membershipInfo, attributesInfo, groupAndSubgroups, groups);
        }
        return groups;
    }

    private void fillMembersAndAddGroupResource(GroupContents group, Optional<String> nameAttribute, Map<Long, EntityInGroupData> membershipInfo, Map<Long, EntityInGroupData> membershipInfoForAttr, Map<String, GroupContents> groupAndSubgroups, List<GroupData> groups) {
        ArrayList<GroupMember> members = new ArrayList<GroupMember>();
        membershipInfo.values().stream().filter(e -> e.groups.contains(group.getGroup().getPathEncoded())).forEach(e -> members.add(this.mapToUserMember((EntityInGroupData)e, Optional.ofNullable((EntityInGroupData)membershipInfoForAttr.get(e.entity.getId())), nameAttribute)));
        groupAndSubgroups.values().stream().filter(g -> Group.isDirectChild((String)g.getGroup().getPathEncoded(), (String)group.getGroup().getPathEncoded())).forEach(g -> {
            members.add(this.mapToGroupMemeber((GroupContents)g));
            this.fillMembersAndAddGroupResource((GroupContents)g, nameAttribute, membershipInfo, membershipInfoForAttr, groupAndSubgroups, groups);
        });
        groups.add(GroupData.builder().withDisplayName(group.getGroup().getDisplayedNameShort(this.msg).getValue(this.msg)).withId(group.getGroup().getPathEncoded()).withMembers(members).build());
    }

    private GroupMember mapToGroupMemeber(GroupContents group) {
        return GroupMember.builder().withValue(group.getGroup().getPathEncoded()).withType(GroupMember.MemberType.Group).withDisplayName(group.getGroup().getDisplayedNameShort(this.msg).getValue(this.msg)).build();
    }

    private GroupMember mapToUserMember(EntityInGroupData entityInGroupData, Optional<EntityInGroupData> entityInGroupDataForAttr, Optional<String> nameAttribute) {
        AttributeExt displayedName;
        Identity persistence = entityInGroupData.entity.getIdentities().stream().filter(i -> i.getTypeId().equals("persistent")).findFirst().get();
        GroupMember.Builder userMember = GroupMember.builder().withValue(persistence.getComparableValue()).withType(GroupMember.MemberType.User);
        if (nameAttribute.isPresent() && entityInGroupDataForAttr.isPresent() && (displayedName = (AttributeExt)entityInGroupDataForAttr.get().groupAttributesByName.get(nameAttribute.get())) != null && displayedName.getValues().size() > 0) {
            userMember.withDisplayName((String)displayedName.getValues().get(0));
        }
        return userMember.build();
    }

    private void assertIsMembershipGroup(String group) throws EngineException {
        if (this.groupsMan.isPresent(group)) {
            for (String configuredMemebershipGroups : this.configuration.membershipGroups) {
                if (!Group.isChildOrSame((String)group, (String)configuredMemebershipGroups)) continue;
                return;
            }
        }
        log.error("Group " + group + " is out of range for configured membership groups");
        throw new GroupNotFoundException("Invalid group " + group);
    }

    @Component
    static class SCIMGroupRetrievalServiceFactory {
        private final GroupsManagement groupMan;
        private final BulkGroupQueryService bulkService;
        private final GroupAuthzService.SCIMGroupAuthzServiceFactory authzManFactory;
        private final MessageSource msg;
        private final AttributeSupport attrSupport;

        @Autowired
        SCIMGroupRetrievalServiceFactory(MessageSource msg, @Qualifier(value="insecure") GroupsManagement groupMan, @Qualifier(value="insecure") BulkGroupQueryService bulkService, GroupAuthzService.SCIMGroupAuthzServiceFactory authzManFactory, AttributeSupport attrSupport) {
            this.groupMan = groupMan;
            this.bulkService = bulkService;
            this.authzManFactory = authzManFactory;
            this.msg = msg;
            this.attrSupport = attrSupport;
        }

        GroupRetrievalService getService(SCIMEndpointDescription configuration) {
            return new GroupRetrievalService(this.msg, this.authzManFactory.getService(configuration), this.groupMan, this.bulkService, this.attrSupport, configuration);
        }
    }
}

