/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.group;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imunity.scim.SCIMConstants;
import io.imunity.scim.SCIMRestController;
import io.imunity.scim.SCIMRestControllerFactory;
import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.group.GroupAssemblyService;
import io.imunity.scim.group.GroupId;
import io.imunity.scim.group.GroupRetrievalService;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.exceptions.EngineException;

@Produces(value={"application/json"})
@Path(value="")
public class GroupRestController
implements SCIMRestController {
    public static final String GROUP_LOCATION = "/Groups";
    private static final Logger log = Log.getLogger((String)"unity.server.scim", GroupRestController.class);
    private final ObjectMapper mapper = SCIMConstants.MAPPER;
    private final GroupRetrievalService groupRetrievalService;
    private final GroupAssemblyService groupAssemblyService;

    GroupRestController(GroupRetrievalService groupRetrievalService, GroupAssemblyService groupAssemblyService) {
        this.groupRetrievalService = groupRetrievalService;
        this.groupAssemblyService = groupAssemblyService;
    }

    @Path(value="/Groups")
    @GET
    public Response getGroups(@Context UriInfo uriInfo) throws EngineException, JsonProcessingException {
        log.debug("Get groups");
        return Response.ok().entity((Object)this.mapper.writeValueAsString(this.groupAssemblyService.mapToGroupsResource(this.groupRetrievalService.getGroups()))).contentLocation(uriInfo.getRequestUri()).build();
    }

    @Path(value="/Groups/{id}")
    @GET
    public Response getGroup(@PathParam(value="id") String groupId, @Context UriInfo uriInfo) throws EngineException, JsonProcessingException {
        log.debug("Get group with id: {}", (Object)groupId);
        return Response.ok().entity((Object)this.mapper.writeValueAsString((Object)this.groupAssemblyService.mapToGroupResource(this.groupRetrievalService.getGroup(new GroupId(groupId))))).contentLocation(uriInfo.getRequestUri()).build();
    }

    @Component
    static class SCIMGroupRestControllerFactory
    implements SCIMRestControllerFactory {
        private final GroupRetrievalService.SCIMGroupRetrievalServiceFactory retServiceFactory;
        private final GroupAssemblyService.SCIMGroupResourceAssemblyServiceFactory assemblyServiceFactory;

        @Autowired
        SCIMGroupRestControllerFactory(GroupRetrievalService.SCIMGroupRetrievalServiceFactory retServiceFactory, GroupAssemblyService.SCIMGroupResourceAssemblyServiceFactory assemblyServiceFactory) {
            this.retServiceFactory = retServiceFactory;
            this.assemblyServiceFactory = assemblyServiceFactory;
        }

        @Override
        public GroupRestController getController(SCIMEndpointDescription configuration) {
            return new GroupRestController(this.retServiceFactory.getService(configuration), this.assemblyServiceFactory.getService(configuration));
        }
    }
}

