/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.group;

import java.util.Objects;

class GroupMember {
    final String value;
    final String displayName;
    final MemberType type;

    private GroupMember(Builder builder) {
        this.value = builder.value;
        this.displayName = builder.displayName;
        this.type = builder.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.displayName, this.type, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupMember other = (GroupMember)obj;
        return Objects.equals(this.displayName, other.displayName) && this.type == other.type && Objects.equals(this.value, other.value);
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String value;
        private String displayName;
        private MemberType type;

        private Builder() {
        }

        Builder withValue(String value) {
            this.value = value;
            return this;
        }

        Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        Builder withType(MemberType type) {
            this.type = type;
            return this;
        }

        GroupMember build() {
            return new GroupMember(this);
        }
    }

    static enum MemberType {
        Group,
        User;

    }
}

