/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.group;

import io.imunity.scim.group.GroupMember;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class GroupData {
    final String id;
    final String displayName;
    final List<GroupMember> members;

    private GroupData(Builder builder) {
        this.id = builder.id;
        this.displayName = builder.displayName;
        this.members = List.copyOf(builder.members);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.id, this.members);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupData other = (GroupData)obj;
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals(this.members, other.members);
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String id;
        private String displayName;
        private List<GroupMember> members = Collections.emptyList();

        private Builder() {
        }

        Builder withId(String id) {
            this.id = id;
            return this;
        }

        Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        Builder withMembers(List<GroupMember> members) {
            this.members = members;
            return this;
        }

        GroupData build() {
            return new GroupData(this);
        }
    }
}

