/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.group;

import eu.unicore.util.configuration.ConfigurationException;
import io.imunity.scim.common.ListResponse;
import io.imunity.scim.common.Meta;
import io.imunity.scim.common.ResourceType;
import io.imunity.scim.config.SCIMEndpointDescription;
import io.imunity.scim.config.SchemaType;
import io.imunity.scim.group.GroupData;
import io.imunity.scim.group.GroupMember;
import io.imunity.scim.group.SCIMGroupMemberResource;
import io.imunity.scim.group.SCIMGroupResource;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.springframework.stereotype.Component;

class GroupAssemblyService {
    private SCIMEndpointDescription configuration;

    GroupAssemblyService(SCIMEndpointDescription configuration) {
        this.configuration = configuration;
    }

    SCIMGroupResource mapToGroupResource(GroupData group) {
        this.assertGroupSchemasAreActive();
        return this.mapToSingleGroupResource(group);
    }

    ListResponse<SCIMGroupResource> mapToGroupsResource(List<GroupData> groups) {
        this.assertGroupSchemasAreActive();
        List groupsResource = groups.stream().map(u -> this.mapToSingleGroupResource((GroupData)u)).collect(Collectors.toList());
        return ListResponse.builder().withResources(groupsResource).withTotalResults(groupsResource.size()).build();
    }

    private SCIMGroupResource mapToSingleGroupResource(GroupData group) {
        return ((SCIMGroupResource.Builder)((SCIMGroupResource.Builder)SCIMGroupResource.builder().withDisplayName(group.displayName).withId(group.id)).withMeta(Meta.builder().withResourceType(ResourceType.GROUP.getName()).withLocation(this.getGroupLocation(group.id)).build())).withMembers(group.members.stream().map(m -> this.mapToMember((GroupMember)m)).collect(Collectors.toList())).build();
    }

    private SCIMGroupMemberResource mapToMember(GroupMember member) {
        return SCIMGroupMemberResource.builder().withValue(member.value).withRef(member.type.equals((Object)GroupMember.MemberType.Group) ? this.getGroupLocation(member.value) : this.getUserLocation(member.value)).withType(member.type.toString()).withDisplay(member.displayName).build();
    }

    private URI getGroupLocation(String group) {
        return UriBuilder.fromUri((URI)this.configuration.baseLocation).path("/Groups").path(URLEncoder.encode(group, StandardCharsets.UTF_8)).build(new Object[0]);
    }

    private URI getUserLocation(String user) {
        return UriBuilder.fromUri((URI)this.configuration.baseLocation).path("/Users/" + user).build(new Object[0]);
    }

    private void assertGroupSchemasAreActive() {
        if (this.configuration.schemas.stream().filter(s -> (s.type.equals((Object)SchemaType.GROUP) || s.type.equals((Object)SchemaType.GROUP_CORE)) && s.enable).count() == 0L) {
            throw new ConfigurationException("No group schemas are active");
        }
    }

    @Component
    static class SCIMGroupResourceAssemblyServiceFactory {
        SCIMGroupResourceAssemblyServiceFactory() {
        }

        GroupAssemblyService getService(SCIMEndpointDescription configuration) {
            return new GroupAssemblyService(configuration);
        }
    }
}

