/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.exception.providers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.imunity.scim.exception.SCIMException;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;
import pl.edu.icm.unity.Constants;

@JsonPropertyOrder(value={"schemas", "status"})
@JsonDeserialize(builder=Builder.class)
class ErrorResponse {
    static final String SCHEMA = "urn:ietf:params:scim:api:messages:2.0:Error";
    public final Set<String> schemas;
    public final int status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final SCIMException.ScimErrorType scimType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String detail;

    ErrorResponse(Builder builder) {
        this.schemas = builder.schemas;
        this.status = builder.status;
        this.scimType = builder.scimType;
        this.detail = builder.detail;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detail, this.schemas, this.scimType, this.status});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)obj;
        return Objects.equals(this.detail, other.detail) && Objects.equals(this.schemas, other.schemas) && this.scimType == other.scimType && this.status == other.status;
    }

    public String toJsonString() {
        try {
            return Constants.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Shouldn't happen: can't serialize error to JSON string", e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SCIMException.ScimErrorType scimType;
        private Integer status;
        private String detail;
        private Set<String> schemas;

        public Builder() {
            this.withSchemas(Set.of(ErrorResponse.SCHEMA));
        }

        public Builder withSchemas(Set<String> schemas) {
            this.schemas = schemas;
            return this;
        }

        public Builder withStatus(Integer status) {
            this.status = status;
            return this;
        }

        public Builder withScimType(SCIMException.ScimErrorType scimType) {
            this.scimType = scimType;
            return this;
        }

        public Builder withDetail(String detail) {
            this.detail = detail;
            return this;
        }

        public ErrorResponse build() {
            Assert.notNull(this.schemas, (String)"schemas cannot be null.");
            Assert.notEmpty(this.schemas, (String)"schemas cannot be empty.");
            Assert.notNull((Object)this.status, (String)"status cannot be null.");
            return new ErrorResponse(this);
        }
    }
}

