/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.exception.providers;

import io.imunity.scim.exception.providers.ErrorResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.authn.AuthenticationException;
import pl.edu.icm.unity.exceptions.AuthorizationException;

@Provider
class EngineExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = Log.getLogger((String)"unity.server.scim", EngineExceptionMapper.class);

    EngineExceptionMapper() {
    }

    public Response toResponse(Exception ex) {
        if (ex instanceof AuthorizationException || ex instanceof AuthenticationException) {
            log.debug("Access denied for SCIM API client", (Throwable)ex);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorResponse.builder().withStatus(Response.Status.FORBIDDEN.getStatusCode()).withDetail("Forbidden").build().toJsonString()).type("application/json").build();
        }
        log.debug("Engine exception during SCIM API invocation", (Throwable)ex);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorResponse.builder().withStatus(Response.Status.BAD_REQUEST.getStatusCode()).withDetail("Bad Request").build().toJsonString()).type("application/json").build();
    }
}

