/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import io.imunity.scim.config.SchemaType;
import io.imunity.scim.console.AttributeDefinitionWithMappingBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SchemaWithMappingBean {
    private String id;
    private SchemaType type = SchemaType.USER;
    private String name;
    private String description;
    private boolean enable;
    private List<AttributeDefinitionWithMappingBean> attributes = new ArrayList<AttributeDefinitionWithMappingBean>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected SchemaWithMappingBean clone() {
        SchemaWithMappingBean clone = new SchemaWithMappingBean();
        clone.setAttributes(this.attributes.stream().map(a -> a.clone()).collect(Collectors.toList()));
        clone.setName(this.name);
        clone.setId(this.id);
        clone.setEnable(this.enable);
        clone.setDescription(this.description);
        clone.setType(this.type);
        return clone;
    }

    public List<AttributeDefinitionWithMappingBean> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributeDefinitionWithMappingBean> attributes) {
        this.attributes = attributes;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean hasInvalidMappings() {
        for (AttributeDefinitionWithMappingBean bean : this.attributes) {
            if (bean == null || bean.inferAttributeNamesWithInvalidMapping().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public SchemaType getType() {
        return this.type;
    }

    public void setType(SchemaType type) {
        this.type = type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.description, this.enable, this.id, this.name, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaWithMappingBean other = (SchemaWithMappingBean)obj;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.description, other.description) && this.enable == other.enable && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type);
    }
}

