/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import io.imunity.scim.config.SchemaType;
import io.imunity.scim.console.AttributesEditMode;
import io.imunity.scim.console.ConfigurationVaadinBeanMapper;
import io.imunity.scim.console.EditSchemaSubView;
import io.imunity.scim.console.SCIMServiceConfigurationBean;
import io.imunity.scim.console.SchemaWithMappingBean;
import io.imunity.scim.schema.SchemaResourceDeserialaizer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.config.UnityServerConfiguration;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.exceptions.RuntimeEngineException;
import pl.edu.icm.unity.webui.common.FileUploder;
import pl.edu.icm.unity.webui.common.GridWithActionColumn;
import pl.edu.icm.unity.webui.common.Images;
import pl.edu.icm.unity.webui.common.NotificationPopup;
import pl.edu.icm.unity.webui.common.SingleActionHandler;
import pl.edu.icm.unity.webui.common.StandardButtonsHelper;
import pl.edu.icm.unity.webui.common.Styles;
import pl.edu.icm.unity.webui.common.chips.ChipsWithFreeText;
import pl.edu.icm.unity.webui.common.webElements.SubViewSwitcher;
import pl.edu.icm.unity.webui.common.webElements.UnitySubView;
import pl.edu.icm.unity.webui.console.services.ServiceEditorBase;
import pl.edu.icm.unity.webui.console.services.ServiceEditorComponent;

class SCIMServiceEditorSchemaTab
extends CustomComponent
implements ServiceEditorBase.EditorTab {
    private final MessageSource msg;
    private final SubViewSwitcher subViewSwitcher;
    private final UnityServerConfiguration unityServerConfiguration;
    private final EditSchemaSubView.EditSchemaSubViewFactory editSchemaSubViewFactory;
    private final ConfigurationVaadinBeanMapper configurationVaadinBeanMapper;

    private SCIMServiceEditorSchemaTab(MessageSource msg, EditSchemaSubView.EditSchemaSubViewFactory editSchemaSubViewFactory, UnityServerConfiguration unityServerConfiguration, SubViewSwitcher subViewSwitcher, ConfigurationVaadinBeanMapper configurationVaadinBeanMapper) {
        this.msg = msg;
        this.unityServerConfiguration = unityServerConfiguration;
        this.subViewSwitcher = subViewSwitcher;
        this.editSchemaSubViewFactory = editSchemaSubViewFactory;
        this.configurationVaadinBeanMapper = configurationVaadinBeanMapper;
    }

    void initUI(Binder<SCIMServiceConfigurationBean> configBinder) {
        this.setIcon(Images.attributes.getResource());
        this.setCaption(this.msg.getMessage("SCIMServiceEditorSchemaTab.schemas", new Object[0]));
        VerticalLayout mainWrapper = new VerticalLayout();
        mainWrapper.setMargin(false);
        ChipsWithFreeText membershipAttributes = new ChipsWithFreeText(this.msg);
        membershipAttributes.setCaption(this.msg.getMessage("SCIMServiceEditorSchemaTab.membershipAttributes", new Object[0]));
        configBinder.forField((HasValue)membershipAttributes).bind("membershipAttributes");
        mainWrapper.addComponent((com.vaadin.ui.Component)new FormLayout(new com.vaadin.ui.Component[]{membershipAttributes}));
        SchemasComponent schemas = new SchemasComponent();
        configBinder.forField((HasValue)schemas).bind("schemas");
        mainWrapper.addComponent((com.vaadin.ui.Component)schemas);
        schemas.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            HashSet attr = new HashSet();
            for (SchemaWithMappingBean schema : (List)e.getValue()) {
                if (schema == null) continue;
                schema.getAttributes().forEach(a -> attr.add(a.getAttributeDefinition().getName()));
            }
            membershipAttributes.setItems(attr);
        });
        this.setCompositionRoot((com.vaadin.ui.Component)mainWrapper);
    }

    public String getType() {
        return ServiceEditorComponent.ServiceEditorTab.OTHER.toString();
    }

    public com.vaadin.ui.Component getComponent() {
        return this;
    }

    @Component
    static class SCIMServiceEditorSchemaTabFactory {
        private final EditSchemaSubView.EditSchemaSubViewFactory editSchemaSubViewFactory;
        private final MessageSource msg;
        private final UnityServerConfiguration configuration;
        private final ConfigurationVaadinBeanMapper configurationVaadinBeanMapper;

        SCIMServiceEditorSchemaTabFactory(EditSchemaSubView.EditSchemaSubViewFactory editSchemaSubViewFactory, MessageSource msg, ConfigurationVaadinBeanMapper configurationVaadinBeanMapper, UnityServerConfiguration configuration) {
            this.editSchemaSubViewFactory = editSchemaSubViewFactory;
            this.msg = msg;
            this.configuration = configuration;
            this.configurationVaadinBeanMapper = configurationVaadinBeanMapper;
        }

        SCIMServiceEditorSchemaTab getSCIMServiceEditorSchemaTab(SubViewSwitcher subViewSwitcher) {
            return new SCIMServiceEditorSchemaTab(this.msg, this.editSchemaSubViewFactory, this.configuration, subViewSwitcher, this.configurationVaadinBeanMapper);
        }
    }

    private class SchemasComponent
    extends CustomField<List<SchemaWithMappingBean>> {
        private GridWithActionColumn<SchemaWithMappingBean> schemasGrid;
        private VerticalLayout main;
        private FileUploder uploader;

        public SchemasComponent() {
            this.initUI();
        }

        private void initUI() {
            this.main = new VerticalLayout();
            this.main.setMargin(new MarginInfo(true, false));
            HorizontalLayout buttons = new HorizontalLayout();
            this.main.addComponent((com.vaadin.ui.Component)buttons);
            this.main.setComponentAlignment((com.vaadin.ui.Component)buttons, Alignment.MIDDLE_RIGHT);
            Button add = new Button(SCIMServiceEditorSchemaTab.this.msg.getMessage("create", new Object[0]));
            add.addClickListener((Button.ClickListener & Serializable)e -> {
                this.setComponentError(null);
                this.gotoNew();
            });
            add.setIcon(Images.add.getResource());
            add.setStyleName(Styles.buttonAction.toString());
            Upload upload = new Upload();
            upload.setButtonCaption(SCIMServiceEditorSchemaTab.this.msg.getMessage("SCIMServiceEditorSchemaTab.import", new Object[0]));
            this.uploader = new FileUploder(upload, new ProgressBar(), new Label(), SCIMServiceEditorSchemaTab.this.msg, SCIMServiceEditorSchemaTab.this.unityServerConfiguration.getFileValue("workspaceDirectory", true), () -> this.importUserSchema());
            this.uploader.register();
            upload.setCaption(null);
            buttons.addComponent((com.vaadin.ui.Component)upload);
            buttons.addComponent((com.vaadin.ui.Component)add);
            this.schemasGrid = new GridWithActionColumn(SCIMServiceEditorSchemaTab.this.msg, this.getActionsHandlers(), false);
            this.schemasGrid.addComponentColumn((ValueProvider & Serializable)s -> StandardButtonsHelper.buildLinkButton((String)s.getId(), (Button.ClickListener & Serializable)e -> this.gotoEdit((SchemaWithMappingBean)s)), SCIMServiceEditorSchemaTab.this.msg.getMessage("SCIMServiceEditorSchemaTab.schemaId", new Object[0]), 20);
            this.schemasGrid.addCheckboxColumn((ValueProvider & Serializable)s -> s.isEnable(), SCIMServiceEditorSchemaTab.this.msg.getMessage("SCIMServiceEditorSchemaTab.enabled", new Object[0]), 20);
            this.schemasGrid.addComponentColumn((ValueProvider & Serializable)s -> this.getMappingStatusLabel(!s.getType().equals((Object)SchemaType.GROUP_CORE) && s.hasInvalidMappings()), SCIMServiceEditorSchemaTab.this.msg.getMessage("SCIMServiceEditorSchemaTab.mappingStatus", new Object[0]), 20);
            this.main.addComponent(this.schemasGrid);
        }

        private Label getMappingStatusLabel(boolean warn) {
            Label l = new Label();
            l.setContentMode(ContentMode.HTML);
            l.setValue(!warn ? Images.ok.getHtml() : Images.warn.getHtml());
            return l;
        }

        private void importUserSchema() {
            try {
                SchemaWithMappingBean schema;
                try {
                    schema = SCIMServiceEditorSchemaTab.this.configurationVaadinBeanMapper.mapFromConfigurationSchema(SchemaResourceDeserialaizer.deserializeUserSchemaFromFile(this.uploader.getFile()));
                }
                catch (EngineException | RuntimeEngineException e) {
                    NotificationPopup.showError((MessageSource)SCIMServiceEditorSchemaTab.this.msg, (String)"", (Exception)e);
                    return;
                }
                this.uploader.clear();
                if (this.schemasGrid.getElements().stream().filter(s -> s.getId().equals(schema.getId())).findAny().isPresent()) {
                    NotificationPopup.showError((String)SCIMServiceEditorSchemaTab.this.msg.getMessage("SCIMServiceEditorSchemaTab.schemaExistError", new Object[]{schema.getId()}), (String)"");
                    return;
                }
                this.schemasGrid.addElement((Object)schema);
                this.fireChange();
            }
            catch (IOException e) {
                this.uploader.clear();
                this.fireChange();
                NotificationPopup.showError((MessageSource)SCIMServiceEditorSchemaTab.this.msg, (String)"Can not import schema", (Exception)e);
            }
        }

        private List<SingleActionHandler<SchemaWithMappingBean>> getActionsHandlers() {
            SingleActionHandler edit = SingleActionHandler.builder4Edit((MessageSource)SCIMServiceEditorSchemaTab.this.msg, SchemaWithMappingBean.class).withHandler(r -> {
                SchemaWithMappingBean edited = (SchemaWithMappingBean)r.iterator().next();
                this.gotoEdit(edited);
            }).build();
            SingleActionHandler remove = SingleActionHandler.builder4Delete((MessageSource)SCIMServiceEditorSchemaTab.this.msg, SchemaWithMappingBean.class).withHandler(r -> {
                SchemaWithMappingBean schema = (SchemaWithMappingBean)r.iterator().next();
                this.schemasGrid.removeElement((Object)schema);
                this.fireChange();
            }).withDisabledPredicate(s -> !this.getEditMode((SchemaWithMappingBean)s).equals((Object)AttributesEditMode.FULL_EDIT)).build();
            return Arrays.asList(edit, remove);
        }

        private void gotoNew() {
            this.gotoEditSubView(null, s -> {
                SCIMServiceEditorSchemaTab.this.subViewSwitcher.exitSubView();
                this.schemasGrid.addElement(s);
            });
        }

        private void gotoEdit(SchemaWithMappingBean edited) {
            this.gotoEditSubView(edited, s -> {
                this.schemasGrid.replaceElement((Object)edited, s);
                SCIMServiceEditorSchemaTab.this.subViewSwitcher.exitSubView();
            });
        }

        private void gotoEditSubView(SchemaWithMappingBean edited, Consumer<SchemaWithMappingBean> onConfirm) {
            try {
                EditSchemaSubView subView = SCIMServiceEditorSchemaTab.this.editSchemaSubViewFactory.getSubView(this.schemasGrid.getElements().stream().map(s -> s.getId()).collect(Collectors.toList()), edited, this.getEditMode(edited), s -> {
                    onConfirm.accept((SchemaWithMappingBean)s);
                    this.fireChange();
                    this.schemasGrid.focus();
                }, () -> {
                    SCIMServiceEditorSchemaTab.this.subViewSwitcher.exitSubView();
                    this.schemasGrid.focus();
                });
                SCIMServiceEditorSchemaTab.this.subViewSwitcher.goToSubView((UnitySubView)subView);
            }
            catch (EngineException e) {
                NotificationPopup.showError((MessageSource)SCIMServiceEditorSchemaTab.this.msg, (String)"Can not edit schema", (Exception)((Object)e));
            }
        }

        public List<SchemaWithMappingBean> getValue() {
            return this.schemasGrid.getElements();
        }

        protected com.vaadin.ui.Component initContent() {
            return this.main;
        }

        protected void doSetValue(List<SchemaWithMappingBean> value) {
            this.schemasGrid.setItems(value);
        }

        private void fireChange() {
            this.fireEvent((EventObject)new HasValue.ValueChangeEvent((com.vaadin.ui.Component)this, (Object)this.schemasGrid.getElements(), true));
        }

        private AttributesEditMode getEditMode(SchemaWithMappingBean schema) {
            if (schema != null) {
                if (schema.getType().equals((Object)SchemaType.USER_CORE)) {
                    return AttributesEditMode.EDIT_MAPPING_ONLY;
                }
                if (schema.getType().equals((Object)SchemaType.GROUP_CORE)) {
                    return AttributesEditMode.HIDE_MAPPING;
                }
            }
            return AttributesEditMode.FULL_EDIT;
        }
    }
}

