/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.ui.Component;
import io.imunity.scim.console.SCIMServiceConfigurationBean;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.types.basic.Group;
import pl.edu.icm.unity.types.endpoint.EndpointTypeDescription;
import pl.edu.icm.unity.webui.common.CollapsibleLayout;
import pl.edu.icm.unity.webui.common.FormLayoutWithFixedCaptionWidth;
import pl.edu.icm.unity.webui.common.chips.ChipsWithTextfield;
import pl.edu.icm.unity.webui.common.groups.MandatoryGroupSelection;
import pl.edu.icm.unity.webui.common.groups.OptionalGroupExcludingChildrenSelection;
import pl.edu.icm.unity.webui.console.services.DefaultServiceDefinition;
import pl.edu.icm.unity.webui.console.services.tabs.GeneralTab;

public class SCIMServiceEditorGeneralTab
extends GeneralTab {
    private Binder<SCIMServiceConfigurationBean> restBinder;
    private final List<Group> allGroups;

    public SCIMServiceEditorGeneralTab(MessageSource msg, EndpointTypeDescription type, List<String> usedEndpointsPaths, Set<String> serverContextPaths, List<Group> allGroups) {
        super(msg, type, usedEndpointsPaths, serverContextPaths);
        this.allGroups = List.copyOf(allGroups);
    }

    public void initUI(Binder<DefaultServiceDefinition> serviceBinder, Binder<SCIMServiceConfigurationBean> restBinder, boolean editMode) {
        super.initUI(serviceBinder, editMode);
        this.restBinder = restBinder;
        this.mainLayout.addComponent(this.buildScimSection());
        this.mainLayout.addComponent(this.buildCorsSection());
    }

    private Component buildScimSection() {
        FormLayoutWithFixedCaptionWidth main = new FormLayoutWithFixedCaptionWidth();
        main.setMargin(false);
        MandatoryGroupSelection rootGroup = new MandatoryGroupSelection(this.msg);
        rootGroup.setCaption(this.msg.getMessage("SCIMServiceEditorGeneralTab.rootGroup", new Object[0]));
        rootGroup.setItems(this.allGroups);
        main.addComponent((Component)rootGroup);
        this.restBinder.forField((HasValue)rootGroup).asRequired().bind("rootGroup");
        OptionalGroupExcludingChildrenSelection memeberShipGroups = new OptionalGroupExcludingChildrenSelection(this.msg);
        memeberShipGroups.setSkipRemoveInvalidSelections(true);
        memeberShipGroups.setCaption(this.msg.getMessage("SCIMServiceEditorGeneralTab.memebershipGroups", new Object[0]));
        memeberShipGroups.setItems(this.allGroups);
        main.addComponent((Component)memeberShipGroups);
        this.restBinder.forField((HasValue)memeberShipGroups).asRequired().withValidator((Validator & Serializable)(value, context) -> {
            if (value == null || value.isEmpty()) {
                return ValidationResult.error((String)this.msg.getMessage("fieldRequired", new Object[0]));
            }
            return ValidationResult.ok();
        }).bind("membershipGroups");
        CollapsibleLayout corsSection = new CollapsibleLayout(this.msg.getMessage("SCIMServiceEditorGeneralTab.scimGroups", new Object[0]), (Component)main);
        corsSection.expand();
        return corsSection;
    }

    private Component buildCorsSection() {
        FormLayoutWithFixedCaptionWidth main = new FormLayoutWithFixedCaptionWidth();
        main.setMargin(false);
        ChipsWithTextfield allowedCORSheaders = new ChipsWithTextfield(this.msg);
        allowedCORSheaders.setCaption(this.msg.getMessage("RestAdminServiceEditorComponent.allowedCORSheaders", new Object[0]));
        this.restBinder.forField((HasValue)allowedCORSheaders).bind("allowedCORSheaders");
        main.addComponent((Component)allowedCORSheaders);
        ChipsWithTextfield allowedCORSorigins = new ChipsWithTextfield(this.msg);
        allowedCORSorigins.setCaption(this.msg.getMessage("RestAdminServiceEditorComponent.allowedCORSorigins", new Object[0]));
        main.addComponent((Component)allowedCORSorigins);
        this.restBinder.forField((HasValue)allowedCORSorigins).bind("allowedCORSorigins");
        CollapsibleLayout corsSection = new CollapsibleLayout(this.msg.getMessage("RestAdminServiceEditorComponent.cors", new Object[0]), (Component)main);
        return corsSection;
    }
}

