/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.vaadin.data.Binder;
import io.imunity.scim.SCIMEndpoint;
import io.imunity.scim.config.SCIMEndpointPropertiesConfigurationMapper;
import io.imunity.scim.console.ConfigurationVaadinBeanMapper;
import io.imunity.scim.console.SCIMServiceConfigurationBean;
import io.imunity.scim.console.SCIMServiceEditorGeneralTab;
import io.imunity.scim.console.SCIMServiceEditorSchemaTab;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.webui.common.FormValidationException;
import pl.edu.icm.unity.webui.console.services.DefaultServiceDefinition;
import pl.edu.icm.unity.webui.console.services.ServiceDefinition;
import pl.edu.icm.unity.webui.console.services.ServiceEditorBase;
import pl.edu.icm.unity.webui.console.services.tabs.AuthenticationTab;

class SCIMServiceEditorComponent
extends ServiceEditorBase {
    private Binder<SCIMServiceConfigurationBean> restBinder;
    private Binder<DefaultServiceDefinition> serviceBinder;
    private final ConfigurationVaadinBeanMapper configurationVaadinBeanMapper;

    public SCIMServiceEditorComponent(MessageSource msg, ConfigurationVaadinBeanMapper configurationVaadinBeanMapper, SCIMServiceEditorGeneralTab generalTab, AuthenticationTab authTab, SCIMServiceEditorSchemaTab schemaTab, DefaultServiceDefinition toEdit) {
        super(msg);
        this.configurationVaadinBeanMapper = configurationVaadinBeanMapper;
        boolean editMode = toEdit != null;
        this.restBinder = new Binder(SCIMServiceConfigurationBean.class);
        this.serviceBinder = new Binder(DefaultServiceDefinition.class);
        generalTab.initUI(this.serviceBinder, this.restBinder, editMode);
        this.registerTab((ServiceEditorBase.EditorTab)generalTab);
        authTab.initUI(this.serviceBinder);
        this.registerTab((ServiceEditorBase.EditorTab)authTab);
        schemaTab.initUI(this.restBinder);
        this.registerTab(schemaTab);
        this.serviceBinder.setBean((Object)(editMode ? toEdit : new DefaultServiceDefinition(SCIMEndpoint.TYPE.getName())));
        SCIMServiceConfigurationBean config = new SCIMServiceConfigurationBean(configurationVaadinBeanMapper);
        if (editMode && toEdit.getConfiguration() != null) {
            config = configurationVaadinBeanMapper.mapToBean(SCIMEndpointPropertiesConfigurationMapper.fromProperties(toEdit.getConfiguration()));
        }
        this.restBinder.setBean((Object)config);
    }

    ServiceDefinition getServiceDefiniton() throws FormValidationException {
        boolean hasErrors = this.serviceBinder.validate().hasErrors();
        if (hasErrors |= this.restBinder.validate().hasErrors()) {
            this.setErrorInTabs();
            throw new FormValidationException();
        }
        DefaultServiceDefinition service = (DefaultServiceDefinition)this.serviceBinder.getBean();
        try {
            service.setConfiguration(SCIMEndpointPropertiesConfigurationMapper.toProperties(this.configurationVaadinBeanMapper.mapToConfigurationBean((SCIMServiceConfigurationBean)this.restBinder.getBean())));
        }
        catch (JsonProcessingException e) {
            this.setErrorInTabs();
            throw new FormValidationException();
        }
        return service;
    }
}

