/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import io.imunity.scim.SCIMEndpoint;
import io.imunity.scim.console.ConfigurationVaadinBeanMapper;
import io.imunity.scim.console.SCIMServiceEditorComponent;
import io.imunity.scim.console.SCIMServiceEditorGeneralTab;
import io.imunity.scim.console.SCIMServiceEditorSchemaTab;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.AuthenticationFlowManagement;
import pl.edu.icm.unity.engine.api.AuthenticatorManagement;
import pl.edu.icm.unity.engine.api.EndpointManagement;
import pl.edu.icm.unity.engine.api.RealmsManagement;
import pl.edu.icm.unity.engine.api.bulk.BulkGroupQueryService;
import pl.edu.icm.unity.engine.api.server.NetworkServer;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.rest.jwt.endpoint.JWTManagementEndpoint;
import pl.edu.icm.unity.types.authn.AuthenticationFlowDefinition;
import pl.edu.icm.unity.types.authn.AuthenticatorInfo;
import pl.edu.icm.unity.types.basic.Group;
import pl.edu.icm.unity.webui.common.FormValidationException;
import pl.edu.icm.unity.webui.common.webElements.SubViewSwitcher;
import pl.edu.icm.unity.webui.console.services.DefaultServiceDefinition;
import pl.edu.icm.unity.webui.console.services.ServiceDefinition;
import pl.edu.icm.unity.webui.console.services.ServiceEditor;
import pl.edu.icm.unity.webui.console.services.ServiceEditorComponent;
import pl.edu.icm.unity.webui.console.services.tabs.AuthenticationTab;

class SCIMServiceEditor
implements ServiceEditor {
    private final MessageSource msg;
    private final List<String> allRealms;
    private final List<Group> allGroups;
    private final List<AuthenticationFlowDefinition> flows;
    private final List<AuthenticatorInfo> authenticators;
    private final List<String> usedPaths;
    private final Set<String> serverContextPaths;
    private final SubViewSwitcher subViewSwitcher;
    private SCIMServiceEditorComponent editor;
    private final SCIMServiceEditorSchemaTab.SCIMServiceEditorSchemaTabFactory editorSchemaTabFactory;
    private final ConfigurationVaadinBeanMapper configurationVaadinBeanMapper;

    SCIMServiceEditor(MessageSource msg, SubViewSwitcher subViewSwitcher, List<String> allRealms, List<AuthenticationFlowDefinition> flows, List<AuthenticatorInfo> authenticators, List<String> usedPaths, Set<String> serverContextPaths, List<Group> allGroups, SCIMServiceEditorSchemaTab.SCIMServiceEditorSchemaTabFactory editorSchemaTabFactory, ConfigurationVaadinBeanMapper configurationVaadinBeanMapper) {
        this.msg = msg;
        this.allRealms = allRealms;
        this.authenticators = authenticators;
        this.flows = flows;
        this.usedPaths = usedPaths;
        this.serverContextPaths = serverContextPaths;
        this.allGroups = allGroups;
        this.subViewSwitcher = subViewSwitcher;
        this.editorSchemaTabFactory = editorSchemaTabFactory;
        this.configurationVaadinBeanMapper = configurationVaadinBeanMapper;
    }

    public ServiceEditorComponent getEditor(ServiceDefinition endpoint) {
        SCIMServiceEditorGeneralTab restAdminServiceEditorGeneralTab = new SCIMServiceEditorGeneralTab(this.msg, SCIMEndpoint.TYPE, this.usedPaths, this.serverContextPaths, this.allGroups);
        AuthenticationTab authenticationTab = new AuthenticationTab(this.msg, this.flows, this.authenticators, this.allRealms, JWTManagementEndpoint.TYPE.getSupportedBinding());
        SCIMServiceEditorSchemaTab schemaTab = this.editorSchemaTabFactory.getSCIMServiceEditorSchemaTab(this.subViewSwitcher);
        this.editor = new SCIMServiceEditorComponent(this.msg, this.configurationVaadinBeanMapper, restAdminServiceEditorGeneralTab, authenticationTab, schemaTab, (DefaultServiceDefinition)endpoint);
        return this.editor;
    }

    public ServiceDefinition getEndpointDefiniton() throws FormValidationException {
        return this.editor.getServiceDefiniton();
    }

    @Component
    static class SCIMServiceEditorFactory {
        private final MessageSource msg;
        private final EndpointManagement endpointMan;
        private final RealmsManagement realmsMan;
        private final AuthenticationFlowManagement flowsMan;
        private final AuthenticatorManagement authMan;
        private final NetworkServer networkServer;
        private final BulkGroupQueryService bulkService;
        private final SCIMServiceEditorSchemaTab.SCIMServiceEditorSchemaTabFactory editorSchemaTabFactory;
        private final ConfigurationVaadinBeanMapper configurationVaadinBeanMapper;

        @Autowired
        SCIMServiceEditorFactory(MessageSource msg, EndpointManagement endpointMan, RealmsManagement realmsMan, AuthenticationFlowManagement flowsMan, AuthenticatorManagement authMan, NetworkServer networkServer, BulkGroupQueryService bulkService, SCIMServiceEditorSchemaTab.SCIMServiceEditorSchemaTabFactory editorSchemaTabFactory, ConfigurationVaadinBeanMapper configurationVaadinBeanMapper) {
            this.msg = msg;
            this.endpointMan = endpointMan;
            this.realmsMan = realmsMan;
            this.flowsMan = flowsMan;
            this.authMan = authMan;
            this.networkServer = networkServer;
            this.bulkService = bulkService;
            this.editorSchemaTabFactory = editorSchemaTabFactory;
            this.configurationVaadinBeanMapper = configurationVaadinBeanMapper;
        }

        public ServiceEditor getEditor(SubViewSwitcher subViewSwitcher) throws EngineException {
            return new SCIMServiceEditor(this.msg, subViewSwitcher, this.realmsMan.getRealms().stream().map(r -> r.getName()).collect(Collectors.toList()), this.flowsMan.getAuthenticationFlows().stream().collect(Collectors.toList()), this.authMan.getAuthenticators(null).stream().collect(Collectors.toList()), this.endpointMan.getEndpoints().stream().map(e -> e.getContextAddress()).collect(Collectors.toList()), this.networkServer.getUsedContextPaths(), this.bulkService.getGroupAndSubgroups(this.bulkService.getBulkStructuralData("/")).values().stream().map(g -> g.getGroup()).collect(Collectors.toList()), this.editorSchemaTabFactory, this.configurationVaadinBeanMapper);
        }
    }
}

