/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import io.imunity.scim.console.AttributeDefinitionConfigurationList;
import io.imunity.scim.console.AttributeDefinitionWithMappingBean;
import io.imunity.scim.console.AttributeEditContext;
import io.imunity.scim.console.AttributeEditorData;
import io.imunity.scim.console.AttributesEditMode;
import io.imunity.scim.console.SchemaWithMappingBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.AttributeTypeManagement;
import pl.edu.icm.unity.engine.api.identity.IdentityTypeSupport;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.webui.common.CollapsibleLayout;
import pl.edu.icm.unity.webui.common.FieldSizeConstans;
import pl.edu.icm.unity.webui.common.FormLayoutWithFixedCaptionWidth;
import pl.edu.icm.unity.webui.common.FormValidationException;
import pl.edu.icm.unity.webui.common.Images;
import pl.edu.icm.unity.webui.common.NotificationPopup;
import pl.edu.icm.unity.webui.common.StandardButtonsHelper;
import pl.edu.icm.unity.webui.common.Styles;
import pl.edu.icm.unity.webui.common.webElements.UnitySubView;

class EditSchemaSubView
extends CustomComponent
implements UnitySubView {
    private MessageSource msg;
    private Binder<SchemaWithMappingBean> binder;
    private boolean editMode = false;
    private AttributesEditMode attributesEditMode;
    private final IdentityTypeSupport identityTypeSupport;
    private final AttributeTypeManagement attributeTypeManagement;

    private EditSchemaSubView(MessageSource msg, IdentityTypeSupport identityTypeSupport, AttributeTypeManagement attributeTypeManagement, List<String> alreadyUseIds, SchemaWithMappingBean toEdit, AttributesEditMode maapingEditMode, Consumer<SchemaWithMappingBean> onConfirm, Runnable onCancel) throws EngineException {
        this.msg = msg;
        this.attributesEditMode = maapingEditMode;
        this.identityTypeSupport = identityTypeSupport;
        this.attributeTypeManagement = attributeTypeManagement;
        this.editMode = toEdit != null;
        this.binder = new Binder(SchemaWithMappingBean.class);
        VerticalLayout mainView = new VerticalLayout();
        mainView.setMargin(false);
        mainView.addComponent((com.vaadin.ui.Component)this.buildHeaderSection(alreadyUseIds));
        mainView.addComponent(this.buildAttributesSection());
        Runnable onConfirmR = () -> {
            SchemaWithMappingBean schema;
            try {
                schema = this.getSchema();
            }
            catch (FormValidationException e) {
                NotificationPopup.showError((MessageSource)msg, (String)msg.getMessage("EditSchemaSubView.invalidConfiguration", new Object[0]), (Exception)((Object)e));
                return;
            }
            onConfirm.accept(schema);
        };
        mainView.addComponent((com.vaadin.ui.Component)(this.editMode ? StandardButtonsHelper.buildConfirmEditButtonsBar((MessageSource)msg, (Runnable)onConfirmR, (Runnable)onCancel) : StandardButtonsHelper.buildConfirmNewButtonsBar((MessageSource)msg, (Runnable)onConfirmR, (Runnable)onCancel)));
        this.binder.setBean((Object)(this.editMode ? toEdit.clone() : new SchemaWithMappingBean()));
        this.setCompositionRoot((com.vaadin.ui.Component)mainView);
    }

    private FormLayoutWithFixedCaptionWidth buildHeaderSection(List<String> alreadyUseIds) {
        FormLayoutWithFixedCaptionWidth header = new FormLayoutWithFixedCaptionWidth();
        header.setMargin(true);
        TextField id = new TextField(this.msg.getMessage("EditSchemaSubView.id", new Object[0]));
        id.setReadOnly(!this.attributesEditMode.equals((Object)AttributesEditMode.FULL_EDIT));
        id.setWidth(30.0f, FieldSizeConstans.MEDIUM_FIELD_WIDTH_UNIT);
        header.addComponent((com.vaadin.ui.Component)id);
        this.binder.forField((HasValue)id).withValidator((Validator & Serializable)(s, c) -> !this.editMode && alreadyUseIds.contains(s) ? ValidationResult.error((String)this.msg.getMessage("EditSchemaSubView.idExists", new Object[0])) : ValidationResult.ok()).asRequired(this.msg.getMessage("fieldRequired", new Object[0])).bind("id");
        TextField name = new TextField(this.msg.getMessage("EditSchemaSubView.name", new Object[0]));
        header.addComponent((com.vaadin.ui.Component)name);
        name.setReadOnly(!this.attributesEditMode.equals((Object)AttributesEditMode.FULL_EDIT));
        this.binder.forField((HasValue)name).bind("name");
        TextField desc = new TextField(this.msg.getMessage("EditSchemaSubView.description", new Object[0]));
        header.addComponent((com.vaadin.ui.Component)desc);
        desc.setWidth(30.0f, FieldSizeConstans.MEDIUM_FIELD_WIDTH_UNIT);
        desc.setReadOnly(!this.attributesEditMode.equals((Object)AttributesEditMode.FULL_EDIT));
        this.binder.forField((HasValue)desc).bind("description");
        CheckBox enable = new CheckBox(this.msg.getMessage("EditSchemaSubView.enable", new Object[0]));
        header.addComponent((com.vaadin.ui.Component)enable);
        this.binder.forField((HasValue)enable).bind("enable");
        enable.setReadOnly(this.attributesEditMode.equals((Object)AttributesEditMode.HIDE_MAPPING));
        return header;
    }

    private com.vaadin.ui.Component buildAttributesSection() throws EngineException {
        VerticalLayout attributesL = new VerticalLayout();
        attributesL.setMargin(false);
        Label invalidMappingInfo = new Label();
        invalidMappingInfo.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        invalidMappingInfo.addStyleName(Styles.wordWrap.toString());
        VerticalLayout wrapper = new VerticalLayout(new com.vaadin.ui.Component[]{invalidMappingInfo});
        wrapper.addStyleName(Styles.background.toString());
        Panel invalidMappingPanel = new Panel((com.vaadin.ui.Component)wrapper);
        invalidMappingPanel.addStyleName(Styles.warnBackground.toString());
        invalidMappingPanel.addStyleName(Styles.vPanelWell.toString());
        invalidMappingPanel.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        invalidMappingPanel.setCaption(this.msg.getMessage("AttributeDefinitionConfigurationList.invalidMappingAttributes", new Object[0]));
        invalidMappingPanel.setIcon(Images.warn.getResource());
        AttributeDefinitionConfigurationList attributesList = new AttributeDefinitionConfigurationList(this.msg, this.msg.getMessage("AttributeDefinitionConfigurationList.addAttribute", new Object[0]), AttributeEditContext.builder().withDisableComplexAndMulti(false).withAttributesEditMode(this.attributesEditMode).build(), AttributeEditorData.builder().withIdentityTypes(this.getIdentityTypes()).withAttributeTypes(this.getAttributeTypes()).build());
        this.binder.forField((HasValue)attributesList).withValidator((Validator & Serializable)(value, context) -> {
            ArrayList<String> invalidMappingAttr = new ArrayList<String>();
            if (value != null) {
                for (AttributeDefinitionWithMappingBean bean : value) {
                    if (bean == null) continue;
                    invalidMappingAttr.addAll(bean.inferAttributeNamesWithInvalidMapping());
                }
            }
            invalidMappingPanel.setVisible(!invalidMappingAttr.isEmpty() && !this.attributesEditMode.equals((Object)AttributesEditMode.HIDE_MAPPING));
            invalidMappingInfo.setValue(String.join((CharSequence)", ", invalidMappingAttr));
            return value == null || value.stream().filter(a -> a == null).count() > 0L ? ValidationResult.error((String)this.msg.getMessage("fieldRequired", new Object[0])) : ValidationResult.ok();
        }).bind("attributes");
        attributesL.addComponent((com.vaadin.ui.Component)invalidMappingPanel);
        attributesL.addComponent((com.vaadin.ui.Component)attributesList);
        CollapsibleLayout attributesSection = new CollapsibleLayout(this.msg.getMessage("EditSchemaSubView.attributes", new Object[0]), (com.vaadin.ui.Component)attributesL);
        attributesSection.expand();
        return attributesSection;
    }

    private List<String> getAttributeTypes() throws EngineException {
        return this.attributeTypeManagement.getAttributeTypes().stream().map(a -> a.getName()).collect(Collectors.toList());
    }

    private List<String> getIdentityTypes() throws EngineException {
        return this.identityTypeSupport.getIdentityTypes().stream().filter(t -> !this.identityTypeSupport.getTypeDefinition(t.getName()).isTargeted()).map(t -> t.getName()).collect(Collectors.toList());
    }

    private SchemaWithMappingBean getSchema() throws FormValidationException {
        if (this.binder.validate().hasErrors()) {
            throw new FormValidationException();
        }
        return (SchemaWithMappingBean)this.binder.getBean();
    }

    public List<String> getBredcrumbs() {
        if (this.editMode) {
            return Arrays.asList(this.msg.getMessage("EditSchemaSubView.schema", new Object[0]), ((SchemaWithMappingBean)this.binder.getBean()).getId());
        }
        return Arrays.asList(this.msg.getMessage("EditSchemaSubView.newSchema", new Object[0]));
    }

    @Component
    static class EditSchemaSubViewFactory {
        final MessageSource msg;
        final AttributeTypeManagement attributeTypeManagement;
        final IdentityTypeSupport identityTypeSupport;

        EditSchemaSubViewFactory(MessageSource msg, AttributeTypeManagement attributeTypeManagement, IdentityTypeSupport identityTypeSupport) {
            this.msg = msg;
            this.attributeTypeManagement = attributeTypeManagement;
            this.identityTypeSupport = identityTypeSupport;
        }

        EditSchemaSubView getSubView(List<String> alreadyUseIds, SchemaWithMappingBean toEdit, AttributesEditMode attributesEditMode, Consumer<SchemaWithMappingBean> onConfirm, Runnable onCancel) throws EngineException {
            return new EditSchemaSubView(this.msg, this.identityTypeSupport, this.attributeTypeManagement, alreadyUseIds, toEdit, attributesEditMode, onConfirm, onCancel);
        }
    }
}

