/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import io.imunity.scim.config.DataArray;
import io.imunity.scim.config.DataValue;
import io.imunity.scim.config.ReferenceAttributeMapping;
import io.imunity.scim.console.AttributeDefinitionBean;
import io.imunity.scim.console.AttributeEditContext;
import io.imunity.scim.console.AttributeEditorData;
import io.imunity.scim.console.AttributeMappingBean;
import io.imunity.scim.console.DataArrayBean;
import io.imunity.scim.console.DataValueBean;
import io.imunity.scim.console.ReferenceDataBean;
import io.imunity.scim.schema.SCIMAttributeType;
import io.imunity.scim.user.mapping.evaluation.SCIMMvelContextKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.mvel.MVELExpressionContext;
import pl.edu.icm.unity.webui.common.FieldSizeConstans;
import pl.edu.icm.unity.webui.common.FormLayoutWithFixedCaptionWidth;
import pl.edu.icm.unity.webui.common.mvel.MVELExpressionField;

class AttributeMappingComponent
extends CustomField<AttributeMappingBean> {
    private final MessageSource msg;
    private VerticalLayout main;
    private Binder<AttributeMappingBean> binder;
    private ComboBox<DataArrayBean> dataArray;
    private DataValueField dataValue;
    private ReferenceField referenceEditor;
    private final AttributeEditorData editorData;
    private final Supplier<AttributeEditContext> editContextSupplier;

    AttributeMappingComponent(MessageSource msg, AttributeEditorData editorData, Supplier<AttributeEditContext> editContextSupplier) {
        this.msg = msg;
        this.editorData = editorData;
        this.editContextSupplier = editContextSupplier;
        this.init();
    }

    private void init() {
        this.binder = new Binder(AttributeMappingBean.class);
        this.main = new VerticalLayout();
        this.main.setMargin(false);
        FormLayoutWithFixedCaptionWidth header = new FormLayoutWithFixedCaptionWidth();
        header.setMargin(false);
        this.main.addComponent((Component)header);
        this.dataArray = new ComboBox();
        this.dataArray.setWidth(30.0f, FieldSizeConstans.MEDIUM_FIELD_WIDTH_UNIT);
        this.dataArray.setCaption(this.msg.getMessage("AttributeDefinitionConfigurationEditor.dataArray", new Object[0]));
        header.addComponent(this.dataArray);
        ArrayList<DataArrayBean> items = new ArrayList<DataArrayBean>();
        items.addAll(this.editorData.identityTypes.stream().sorted().map(i -> new DataArrayBean(DataArray.DataArrayType.IDENTITY, Optional.of(i))).collect(Collectors.toList()));
        items.addAll(this.editorData.attributeTypes.stream().sorted().map(a -> new DataArrayBean(DataArray.DataArrayType.ATTRIBUTE, Optional.of(a))).collect(Collectors.toList()));
        items.add(new DataArrayBean(DataArray.DataArrayType.MEMBERSHIP, Optional.empty()));
        this.dataArray.setItems(items);
        this.dataArray.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)i -> i != null && i.getType() != null ? this.msg.getMessage("DataArrayType." + i.getType(), new Object[0]) + (i.getValue().isEmpty() ? "" : i.getValue().get()) : "");
        this.dataArray.setEmptySelectionAllowed(false);
        this.binder.forField(this.dataArray).bind("dataArray");
        this.dataValue = new DataValueField(this.msg, this.editorData);
        header.addComponent((Component)this.dataValue);
        this.binder.forField((HasValue)this.dataValue).bind("dataValue");
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, (Object)((AttributeMappingBean)this.binder.getBean()), e.isUserOriginated())));
        this.referenceEditor = new ReferenceField(this.msg);
        this.referenceEditor.addToLayout((Layout)header);
        this.binder.forField((HasValue)this.referenceEditor).bind("dataReference");
    }

    public void update(AttributeDefinitionBean value) {
        if (value == null) {
            return;
        }
        this.dataArray.setVisible(value.isMultiValued());
        this.dataValue.setVisible(!value.getType().equals((Object)SCIMAttributeType.COMPLEX) && !value.getType().equals((Object)SCIMAttributeType.REFERENCE));
        this.dataValue.setMulti(value.isMultiValued(), this.editContextSupplier.get().complexMultiParent);
        this.referenceEditor.setVisible(value.getType().equals((Object)SCIMAttributeType.REFERENCE));
        this.referenceEditor.setMulti(value.isMultiValued());
    }

    public AttributeMappingBean getValue() {
        return (AttributeMappingBean)this.binder.getBean();
    }

    protected Component initContent() {
        return this.main;
    }

    protected void doSetValue(AttributeMappingBean value) {
        this.binder.setBean((Object)value);
    }

    private static class ReferenceField
    extends CustomField<ReferenceDataBean> {
        private final MessageSource msg;
        private ComboBox<ReferenceAttributeMapping.ReferenceType> refToTypeCombo;
        private MVELExpressionField expression;

        public ReferenceField(MessageSource msg) {
            this.msg = msg;
            this.init();
        }

        void init() {
            this.refToTypeCombo = new ComboBox(this.msg.getMessage("ReferenceField.reference", new Object[0]));
            this.refToTypeCombo.setItems((Object[])ReferenceAttributeMapping.ReferenceType.values());
            this.refToTypeCombo.setValue((Object)ReferenceAttributeMapping.ReferenceType.GENERIC);
            this.refToTypeCombo.setEmptySelectionAllowed(false);
            this.refToTypeCombo.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)s -> s == null ? "" : this.msg.getMessage("ReferenceType." + s, new Object[0]));
            this.expression = new MVELExpressionField(this.msg, this.msg.getMessage("ReferenceField.referenceUri", new Object[0]), "", MVELExpressionContext.builder().withTitleKey("AttributeDefinitionConfigurationEditor.dataValue").withEvalToKey("MVELExpressionField.evalToUri").withVars(SCIMMvelContextKey.mapForSingle()).build());
            this.expression.setWidth(30.0f, FieldSizeConstans.MEDIUM_FIELD_WIDTH_UNIT);
            this.refToTypeCombo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateExpressionFiled((HasValue.ValueChangeEvent<ReferenceAttributeMapping.ReferenceType>)e));
            this.expression.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, (Object)this.getValue(), e.isUserOriginated())));
        }

        private void updateExpressionFiled(HasValue.ValueChangeEvent<ReferenceAttributeMapping.ReferenceType> e) {
            MVELExpressionContext context = this.expression.getContext();
            if (((ReferenceAttributeMapping.ReferenceType)((Object)this.refToTypeCombo.getValue())).equals((Object)ReferenceAttributeMapping.ReferenceType.GENERIC)) {
                this.expression.setCaption(this.msg.getMessage("ReferenceField.referenceUri", new Object[0]));
                this.expression.setContext(MVELExpressionContext.builder().withTitleKey("AttributeDefinitionConfigurationEditor.referenceGeneralDataValue").withEvalToKey("MVELExpressionField.evalToUri").withVars(context.vars).build());
            } else {
                this.expression.setCaption(this.msg.getMessage("ReferenceField.referencedResourceId", new Object[0]));
                this.expression.setContext(MVELExpressionContext.builder().withTitleKey(this.getMvelEditorTitleKey()).withEvalToKey(this.getMvelEditorTypeKey()).withVars(context.vars).build());
            }
            this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, (Object)this.getValue(), e.isUserOriginated()));
        }

        private String getMvelEditorTitleKey() {
            switch ((ReferenceAttributeMapping.ReferenceType)((Object)this.refToTypeCombo.getValue())) {
                case USER: {
                    return "AttributeDefinitionConfigurationEditor.referenceUserDataValue";
                }
                case GROUP: {
                    return "AttributeDefinitionConfigurationEditor.referenceGroupDataValue";
                }
            }
            return "AttributeDefinitionConfigurationEditor.referenceGeneralDataValue";
        }

        private String getMvelEditorTypeKey() {
            switch ((ReferenceAttributeMapping.ReferenceType)((Object)this.refToTypeCombo.getValue())) {
                case USER: {
                    return "MVELExpressionField.evalToStringWithUserId";
                }
                case GROUP: {
                    return "MVELExpressionField.evalToStringWithGroupPath";
                }
            }
            return "MVELExpressionField.evalToUri";
        }

        public ReferenceDataBean getValue() {
            return new ReferenceDataBean((ReferenceAttributeMapping.ReferenceType)((Object)this.refToTypeCombo.getValue()), this.expression.getValue());
        }

        protected Component initContent() {
            FormLayoutWithFixedCaptionWidth main = FormLayoutWithFixedCaptionWidth.withShortCaptions();
            main.setMargin(false);
            main.addComponent(this.refToTypeCombo);
            main.addComponent((Component)this.expression);
            return main;
        }

        protected void doSetValue(ReferenceDataBean value) {
            if (value == null) {
                return;
            }
            this.refToTypeCombo.setValue((Object)value.getType());
            this.expression.setValue((Object)value.getExpression());
        }

        void addToLayout(Layout layout) {
            layout.addComponent(this.refToTypeCombo);
            layout.addComponent((Component)this.expression);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.refToTypeCombo.setVisible(visible);
            this.expression.setVisible(visible);
        }

        public void setMulti(boolean multi) {
            MVELExpressionContext context = this.expression.getContext();
            this.expression.setContext(MVELExpressionContext.builder().withTitleKey(context.titleKey).withEvalToKey(context.evalToKey).withVars(multi ? SCIMMvelContextKey.mapForMulti() : SCIMMvelContextKey.mapForSingle()).build());
        }
    }

    private static class DataValueField
    extends CustomField<DataValueBean> {
        private final MessageSource msg;
        private final AttributeEditorData editorData;
        private ComboBox<DataValueBean> dataValue;
        private TabSheet tab;
        private TabSheet.Tab staticValueTab;
        private TabSheet.Tab mvelTab;
        private MVELExpressionField expression;
        private boolean multi;
        private boolean parentMulti;

        public DataValueField(MessageSource msg, AttributeEditorData editorData) {
            this.setCaption(msg.getMessage("AttributeDefinitionConfigurationEditor.dataValue", new Object[0]));
            this.msg = msg;
            this.editorData = editorData;
            this.init();
        }

        void init() {
            this.tab = new TabSheet();
            this.tab.addStyleName("u-logoFieldTabsheet");
            VerticalLayout mainDataLayout = new VerticalLayout();
            mainDataLayout.setMargin(new MarginInfo(true, false));
            this.dataValue = new ComboBox();
            this.dataValue.setWidth(30.0f, FieldSizeConstans.MEDIUM_FIELD_WIDTH_UNIT);
            mainDataLayout.addComponent(this.dataValue);
            this.dataValue.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, (Object)this.getValue(), e.isUserOriginated())));
            this.dataValue.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)i -> i != null && i.getType() != null ? this.msg.getMessage("DataValueType." + i.getType(), new Object[0]) + (i.getValue().isEmpty() ? "" : i.getValue().get()) : "");
            this.dataValue.setEmptySelectionAllowed(false);
            VerticalLayout mainExpressionLayout = new VerticalLayout();
            mainExpressionLayout.setMargin(new MarginInfo(true, false));
            this.expression = new MVELExpressionField(this.msg, null, "", MVELExpressionContext.builder().withTitleKey("AttributeDefinitionConfigurationEditor.dataValue").withEvalToKey("MVELExpressionField.evalToString").withVars(Collections.emptyMap()).build());
            this.expression.setWidth(30.0f, FieldSizeConstans.MEDIUM_FIELD_WIDTH_UNIT);
            this.expression.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, (Object)this.getValue(), e.isUserOriginated())));
            mainExpressionLayout.addComponent((Component)this.expression);
            this.staticValueTab = this.tab.addTab((Component)mainDataLayout, this.msg.getMessage("DataValueField.data", new Object[0]));
            this.mvelTab = this.tab.addTab((Component)mainExpressionLayout, this.msg.getMessage("DataValueField.expression", new Object[0]));
            this.tab.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener & Serializable)e -> this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, (Object)this.getValue(), e.isUserOriginated())));
            this.setItemsForSingleTypeSelect();
        }

        public void setMulti(boolean multiValued, boolean parentMultiValued) {
            if (this.multi == multiValued && this.parentMulti == parentMultiValued) {
                return;
            }
            this.multi = multiValued;
            this.parentMulti = parentMultiValued;
            if (parentMultiValued) {
                this.setAllItems();
                return;
            }
            List<DataValueBean> items = null;
            items = multiValued ? this.setItemsForMultiTypeSelect() : this.setItemsForSingleTypeSelect();
            DataValueBean value = (DataValueBean)this.dataValue.getValue();
            if (value != null && items.stream().filter(a -> a.getType().equals((Object)value.getType())).findAny().isEmpty()) {
                this.dataValue.setValue(null);
            }
        }

        public DataValueBean getValue() {
            if (this.tab.getSelectedTab() != null && this.tab.getSelectedTab().equals(this.mvelTab.getComponent())) {
                return new DataValueBean(DataValue.DataValueType.MVEL, Optional.ofNullable(this.expression.getValue()));
            }
            return (DataValueBean)this.dataValue.getValue();
        }

        private List<DataValueBean> setAllItems() {
            List<DataValueBean> items = this.getIdentitiesAndAttributesItems();
            items.add(new DataValueBean(DataValue.DataValueType.ARRAY, Optional.empty()));
            this.dataValue.setItems(items);
            this.expression.setContext(MVELExpressionContext.builder().withTitleKey("AttributeDefinitionConfigurationEditor.dataValue").withEvalToKey("MVELExpressionField.evalToString").withVars(SCIMMvelContextKey.mapForMulti()).build());
            return items;
        }

        private List<DataValueBean> setItemsForSingleTypeSelect() {
            List<DataValueBean> items = this.getIdentitiesAndAttributesItems();
            this.dataValue.setItems(items);
            this.expression.setContext(MVELExpressionContext.builder().withTitleKey("AttributeDefinitionConfigurationEditor.dataValue").withEvalToKey("MVELExpressionField.evalToString").withVars(SCIMMvelContextKey.mapForSingle()).build());
            return items;
        }

        private List<DataValueBean> getIdentitiesAndAttributesItems() {
            ArrayList<DataValueBean> items = new ArrayList<DataValueBean>();
            items.addAll(this.editorData.identityTypes.stream().sorted().map(a -> new DataValueBean(DataValue.DataValueType.IDENTITY, Optional.ofNullable(a))).collect(Collectors.toList()));
            items.addAll(this.editorData.attributeTypes.stream().sorted().map(a -> new DataValueBean(DataValue.DataValueType.ATTRIBUTE, Optional.ofNullable(a))).collect(Collectors.toList()));
            return items;
        }

        private List<DataValueBean> setItemsForMultiTypeSelect() {
            List<DataValueBean> items = List.of(new DataValueBean(DataValue.DataValueType.ARRAY, Optional.empty()));
            this.dataValue.setItems(List.of(new DataValueBean(DataValue.DataValueType.ARRAY, Optional.empty())));
            this.expression.setContext(MVELExpressionContext.builder().withTitleKey("AttributeDefinitionConfigurationEditor.dataValue").withEvalToKey("MVELExpressionField.evalToString").withVars(SCIMMvelContextKey.mapForMulti()).build());
            return items;
        }

        protected Component initContent() {
            VerticalLayout main = new VerticalLayout(new Component[]{this.tab});
            main.setMargin(false);
            return main;
        }

        protected void doSetValue(DataValueBean value) {
            if (value == null) {
                this.dataValue.setValue(null);
                this.expression.setValue(null);
                return;
            }
            if (value.getType() == null) {
                this.tab.setSelectedTab(this.staticValueTab);
                return;
            }
            if (value.getType().equals((Object)DataValue.DataValueType.MVEL)) {
                this.expression.setValue((Object)value.getValue().orElse(""));
                this.tab.setSelectedTab(this.mvelTab);
            } else {
                this.dataValue.setValue((Object)value);
                this.tab.setSelectedTab(this.staticValueTab);
            }
        }
    }
}

