/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import io.imunity.scim.config.AttributeMapping;
import io.imunity.scim.config.ComplexAttributeMapping;
import io.imunity.scim.config.DataArray;
import io.imunity.scim.config.DataValue;
import io.imunity.scim.config.ReferenceAttributeMapping;
import io.imunity.scim.config.SimpleAttributeMapping;
import io.imunity.scim.config.UndefinedMapping;
import io.imunity.scim.console.AttributeDefinitionBean;
import io.imunity.scim.console.DataArrayBean;
import io.imunity.scim.console.DataValueBean;
import io.imunity.scim.console.ReferenceDataBean;
import io.imunity.scim.schema.SCIMAttributeType;
import java.util.Optional;

public class AttributeMappingBean {
    private DataValueBean dataValue;
    private DataArrayBean dataArray;
    private ReferenceDataBean dataReference;

    public DataValueBean getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(DataValueBean dataValue) {
        this.dataValue = dataValue;
    }

    public DataArrayBean getDataArray() {
        return this.dataArray;
    }

    public void setDataArray(DataArrayBean dataArray) {
        this.dataArray = dataArray;
    }

    public ReferenceDataBean getDataReference() {
        return this.dataReference;
    }

    public void setDataReference(ReferenceDataBean dataReference) {
        this.dataReference = dataReference;
    }

    protected AttributeMappingBean clone() {
        AttributeMappingBean clone = new AttributeMappingBean();
        clone.setDataArray(this.dataArray);
        clone.setDataValue(this.dataValue);
        clone.setDataReference(this.dataReference);
        return clone;
    }

    AttributeMapping toConfiguration(AttributeDefinitionBean attributeDefinition) {
        if (attributeDefinition.getType().equals((Object)SCIMAttributeType.COMPLEX)) {
            return ComplexAttributeMapping.builder().withDataArray(!attributeDefinition.isMultiValued() ? Optional.empty() : AttributeMappingBean.mapDataArray(this.dataArray)).build();
        }
        if (attributeDefinition.getType().equals((Object)SCIMAttributeType.REFERENCE)) {
            if (this.dataReference == null) {
                return new UndefinedMapping();
            }
            return ReferenceAttributeMapping.builder().withDataArray(!attributeDefinition.isMultiValued() ? Optional.empty() : AttributeMappingBean.mapDataArray(this.dataArray)).withExpression(this.dataReference.getExpression()).withType(this.dataReference.getType()).build();
        }
        if (this.dataValue == null) {
            return new UndefinedMapping();
        }
        return SimpleAttributeMapping.builder().withDataArray(!attributeDefinition.isMultiValued() ? Optional.empty() : AttributeMappingBean.mapDataArray(this.dataArray)).withDataValue(DataValue.builder().withType(this.dataValue.getType()).withValue(this.dataValue.getValue().orElse(null)).build()).build();
    }

    private static Optional<DataArray> mapDataArray(DataArrayBean bean) {
        return bean == null || bean.getType() == null ? Optional.empty() : Optional.of(DataArray.builder().withType(bean.getType()).withValue(bean.getValue().orElse(null)).build());
    }
}

