/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import java.util.Collections;
import java.util.List;

class AttributeEditorData {
    final List<String> attributeTypes;
    final List<String> identityTypes;

    private AttributeEditorData(Builder builder) {
        this.attributeTypes = List.copyOf(builder.attributeTypes);
        this.identityTypes = List.copyOf(builder.identityTypes);
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private List<String> attributeTypes = Collections.emptyList();
        private List<String> identityTypes = Collections.emptyList();

        private Builder() {
        }

        Builder withAttributeTypes(List<String> attributeTypes) {
            this.attributeTypes = attributeTypes;
            return this;
        }

        Builder withIdentityTypes(List<String> identityTypes) {
            this.identityTypes = identityTypes;
            return this;
        }

        AttributeEditorData build() {
            return new AttributeEditorData(this);
        }
    }
}

