/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import io.imunity.scim.console.AttributeDefinitionBean;
import io.imunity.scim.console.AttributeMappingBean;
import io.imunity.scim.schema.SCIMAttributeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AttributeDefinitionWithMappingBean {
    private AttributeDefinitionBean attributeDefinition = new AttributeDefinitionBean();
    private AttributeMappingBean attributeMapping = new AttributeMappingBean();

    public int hashCode() {
        return Objects.hash(this.attributeDefinition, this.attributeMapping);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeDefinitionWithMappingBean other = (AttributeDefinitionWithMappingBean)obj;
        return Objects.equals(this.attributeDefinition, other.attributeDefinition) && Objects.equals(this.attributeMapping, other.attributeMapping);
    }

    public AttributeDefinitionBean getAttributeDefinition() {
        return this.attributeDefinition;
    }

    public void setAttributeDefinition(AttributeDefinitionBean attributeDefinition) {
        this.attributeDefinition = attributeDefinition;
    }

    public AttributeMappingBean getAttributeMapping() {
        return this.attributeMapping;
    }

    public void setAttributeMapping(AttributeMappingBean attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    protected AttributeDefinitionWithMappingBean clone() {
        AttributeDefinitionWithMappingBean clone = new AttributeDefinitionWithMappingBean();
        clone.setAttributeDefinition(this.attributeDefinition.clone());
        clone.setAttributeMapping(this.attributeMapping != null ? this.attributeMapping.clone() : null);
        return clone;
    }

    public List<String> inferAttributeNamesWithInvalidMapping() {
        if (this.attributeDefinition == null || this.attributeDefinition.getName().isEmpty()) {
            return Collections.emptyList();
        }
        if (this.attributeMapping == null) {
            return List.of(this.attributeDefinition.getName());
        }
        if (this.attributeDefinition.isMultiValued() && (this.attributeMapping.getDataArray() == null || this.attributeMapping.getDataArray().getType() == null)) {
            return List.of(this.attributeDefinition.getName());
        }
        if (!this.attributeDefinition.getType().equals((Object)SCIMAttributeType.COMPLEX) && (this.attributeDefinition.getType().equals((Object)SCIMAttributeType.REFERENCE) ? this.attributeMapping.getDataReference() == null || this.attributeMapping.getDataReference().getType() == null || this.attributeMapping.getDataReference().getExpression() == null || this.attributeMapping.getDataReference().getExpression().isEmpty() : this.attributeMapping.getDataValue() == null || this.attributeMapping.getDataValue().getType() == null)) {
            return List.of(this.attributeDefinition.getName());
        }
        ArrayList<String> invalid = new ArrayList<String>();
        for (AttributeDefinitionWithMappingBean sa : this.attributeDefinition.getSubAttributesWithMapping()) {
            for (String a : sa.inferAttributeNamesWithInvalidMapping()) {
                invalid.add(this.attributeDefinition.getName() + "." + a);
            }
        }
        return invalid;
    }
}

