/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.console;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.server.ClientConnector;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import io.imunity.scim.console.AttributeDefinitionBean;
import io.imunity.scim.console.AttributeDefinitionConfigurationList;
import io.imunity.scim.console.AttributeEditContext;
import io.imunity.scim.console.AttributeEditorData;
import io.imunity.scim.console.AttributesEditMode;
import io.imunity.scim.schema.SCIMAttributeType;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventObject;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.webui.common.FieldSizeConstans;
import pl.edu.icm.unity.webui.common.FormLayoutWithFixedCaptionWidth;

class AttributeDefinitionComponent
extends CustomField<AttributeDefinitionBean> {
    private final MessageSource msg;
    private TextField name;
    private Binder<AttributeDefinitionBean> binder;
    private final VerticalLayout headerLayout;
    private final VerticalLayout subAttrLayout;
    private final AttributeEditContext context;
    private final AttributeEditorData attributeEditorData;
    private AttributeEditContext editContext;

    AttributeDefinitionComponent(MessageSource msg, AttributeEditContext context, AttributeEditorData attributeEditorData, VerticalLayout attrDefHeaderSlot, VerticalLayout subAttrSlot) {
        this.msg = msg;
        this.headerLayout = attrDefHeaderSlot;
        this.subAttrLayout = subAttrSlot;
        this.context = context;
        this.attributeEditorData = attributeEditorData;
        this.init();
    }

    private void init() {
        this.binder = new Binder(AttributeDefinitionBean.class);
        FormLayoutWithFixedCaptionWidth header = new FormLayoutWithFixedCaptionWidth();
        header.setMargin(false);
        this.headerLayout.addComponent((Component)header);
        this.name = new TextField(this.msg.getMessage("AttributeDefinitionConfigurationEditor.name", new Object[0]));
        header.addComponent((Component)this.name);
        this.name.setReadOnly(!this.context.attributesEditMode.equals((Object)AttributesEditMode.FULL_EDIT));
        this.binder.forField((HasValue)this.name).asRequired().bind("name");
        TextField desc = new TextField(this.msg.getMessage("AttributeDefinitionConfigurationEditor.description", new Object[0]));
        header.addComponent((Component)desc);
        desc.setWidth(30.0f, FieldSizeConstans.MEDIUM_FIELD_WIDTH_UNIT);
        desc.setReadOnly(!this.context.attributesEditMode.equals((Object)AttributesEditMode.FULL_EDIT));
        this.binder.forField((HasValue)desc).bind("description");
        ComboBox type = new ComboBox();
        type.setCaption(this.msg.getMessage("AttributeDefinitionConfigurationEditor.type", new Object[0]));
        type.setItems((Collection)Stream.of(SCIMAttributeType.values()).filter(t -> !this.context.disableComplexAndMulti || !t.equals((Object)SCIMAttributeType.COMPLEX)).collect(Collectors.toList()));
        type.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)t -> t.getName());
        type.setEmptySelectionAllowed(false);
        type.setValue((Object)SCIMAttributeType.STRING);
        type.setReadOnly(!this.context.attributesEditMode.equals((Object)AttributesEditMode.FULL_EDIT));
        header.addComponent((Component)type);
        this.binder.forField((HasValue)type).bind("type");
        CheckBox multi = new CheckBox();
        multi.setCaption(this.msg.getMessage("AttributeDefinitionConfigurationEditor.multiValued", new Object[0]));
        header.addComponent((Component)multi);
        this.binder.forField((HasValue)multi).bind("multiValued");
        multi.setVisible(!this.context.disableComplexAndMulti);
        multi.setReadOnly(!this.context.attributesEditMode.equals((Object)AttributesEditMode.FULL_EDIT));
        FormLayoutWithFixedCaptionWidth subAttrFormLayout = new FormLayoutWithFixedCaptionWidth();
        subAttrFormLayout.setMargin(false);
        this.subAttrLayout.addComponent((Component)subAttrFormLayout);
        this.editContext = AttributeEditContext.builder().withDisableComplexAndMulti(true).withAttributesEditMode(this.context.attributesEditMode).build();
        AttributeDefinitionConfigurationList attributesList = new AttributeDefinitionConfigurationList(this.msg, this.msg.getMessage("AttributeDefinitionConfigurationList.addSubAttribute", new Object[0]), () -> this.editContext, this.attributeEditorData);
        attributesList.setRequiredIndicatorVisible(false);
        this.binder.forField((HasValue)attributesList).withValidator((Validator & Serializable)(value, context) -> value == null || value.stream().filter(a -> a == null).count() > 0L ? ValidationResult.error((String)this.msg.getMessage("fieldRequired", new Object[0])) : ValidationResult.ok()).bind("subAttributesWithMapping");
        multi.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.editContext = AttributeEditContext.builder().withDisableComplexAndMulti(true).withAttributesEditMode(this.context.attributesEditMode).withComplexMultiParent((Boolean)e.getValue()).build();
            attributesList.refreshEditors();
        });
        type.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> {
            if (!((SCIMAttributeType)((Object)((Object)v.getValue()))).equals((Object)SCIMAttributeType.COMPLEX)) {
                attributesList.clear();
            }
            attributesList.setVisible(((SCIMAttributeType)((Object)((Object)v.getValue()))).equals((Object)SCIMAttributeType.COMPLEX));
        });
        attributesList.setVisible(false);
        subAttrFormLayout.addComponent((Component)attributesList);
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, (Object)((AttributeDefinitionBean)this.binder.getBean()), e.isUserOriginated())));
        this.binder.setValidatorsDisabled(true);
        this.headerLayout.addAttachListener((ClientConnector.AttachListener & Serializable)e -> this.binder.setValidatorsDisabled(false));
    }

    public AttributeDefinitionBean getValue() {
        if (this.binder.validate().hasErrors()) {
            return null;
        }
        return (AttributeDefinitionBean)this.binder.getBean();
    }

    protected Component initContent() {
        return new VerticalLayout(new Component[]{this.headerLayout, this.subAttrLayout});
    }

    protected void doSetValue(AttributeDefinitionBean value) {
        this.binder.setBean((Object)value);
    }

    String getHeaderText() {
        return this.name.getValue() == null || this.name.getValue().isEmpty() ? "" : this.name.getValue();
    }
}

