/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.imunity.scim.config.AttributeMapping;
import io.imunity.scim.config.DataArray;
import io.imunity.scim.config.DataValue;
import io.imunity.scim.console.AttributeMappingBean;
import io.imunity.scim.console.DataArrayBean;
import io.imunity.scim.console.DataValueBean;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class SimpleAttributeMapping
implements AttributeMapping {
    public static final String id = "Simple";
    public final Optional<DataArray> dataArray;
    public final DataValue dataValue;

    public static Builder builder() {
        return new Builder();
    }

    private SimpleAttributeMapping(Builder builder) {
        this.dataArray = builder.dataArray;
        this.dataValue = builder.dataValue;
    }

    @Override
    public Optional<DataArray> getDataArray() {
        return this.dataArray;
    }

    @Override
    public AttributeMappingBean toBean() {
        AttributeMappingBean bean = new AttributeMappingBean();
        bean.setDataArray(this.dataArray.isEmpty() ? new DataArrayBean() : new DataArrayBean(this.dataArray.get().type, this.dataArray.get().value));
        bean.setDataValue(new DataValueBean(this.dataValue.type, this.dataValue.value));
        return bean;
    }

    @Override
    public String getEvaluatorId() {
        return id;
    }

    public int hashCode() {
        return Objects.hash(this.dataArray, this.dataValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleAttributeMapping other = (SimpleAttributeMapping)obj;
        return Objects.equals(this.dataArray, other.dataArray) && Objects.equals(this.dataValue, other.dataValue);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<DataArray> dataArray = Optional.empty();
        private DataValue dataValue = DataValue.builder().build();

        private Builder() {
        }

        public SimpleAttributeMapping build() {
            return new SimpleAttributeMapping(this);
        }

        public Builder withDataArray(Optional<DataArray> dataArray) {
            this.dataArray = dataArray;
            return this;
        }

        public Builder withDataValue(DataValue dataValue) {
            this.dataValue = dataValue;
            return this;
        }
    }
}

