/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.imunity.scim.config.AttributeDefinitionWithMapping;
import io.imunity.scim.config.SchemaType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public class SchemaWithMapping {
    public final String id;
    public final SchemaType type;
    public final String name;
    public final String description;
    public final boolean enable;
    public final List<AttributeDefinitionWithMapping> attributesWithMapping;

    private SchemaWithMapping(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.enable = builder.enable;
        this.attributesWithMapping = List.copyOf(builder.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributesWithMapping, this.description, this.id, this.name, this.enable, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaWithMapping other = (SchemaWithMapping)obj;
        return Objects.equals(this.attributesWithMapping, other.attributesWithMapping) && Objects.equals(this.description, other.description) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.enable, other.enable) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String description;
        private boolean enable;
        private List<AttributeDefinitionWithMapping> attributes = Collections.emptyList();
        private SchemaType type;

        private Builder() {
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withType(SchemaType type) {
            this.type = type;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withEnable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public Builder withAttributesWithMapping(List<AttributeDefinitionWithMapping> attributes) {
            this.attributes = attributes;
            return this;
        }

        public SchemaWithMapping build() {
            return new SchemaWithMapping(this);
        }
    }
}

