/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.imunity.scim.SCIMConstants;
import io.imunity.scim.config.SCIMEndpointConfiguration;
import io.imunity.scim.config.SCIMEndpointProperties;
import io.imunity.scim.config.SchemaWithMapping;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.rest.RESTEndpointProperties;

public class SCIMEndpointPropertiesConfigurationMapper {
    private static final Logger log = Log.getLogger((String)"unity.server.scim", SCIMEndpointPropertiesConfigurationMapper.class);

    public static String toProperties(SCIMEndpointConfiguration configuration) throws JsonProcessingException {
        Properties rawRest = new Properties();
        configuration.allowedCorsHeaders.forEach(ach -> rawRest.put("unity.endpoint.scim.allowedCorsHeaders." + (configuration.allowedCorsHeaders.indexOf(ach) + 1), ach));
        configuration.allowedCorsOrigins.forEach(aco -> rawRest.put("unity.endpoint.scim.allowedCorsOrigins." + (configuration.allowedCorsOrigins.indexOf(aco) + 1), aco));
        Properties rawScim = new Properties();
        configuration.membershipGroups.forEach(g -> rawScim.put("unity.endpoint.scim.membershipGroups." + (configuration.membershipGroups.indexOf(g) + 1), g));
        configuration.membershipAttributes.forEach(a -> rawScim.put("unity.endpoint.scim.membershipAttributes." + (configuration.membershipAttributes.indexOf(a) + 1), a));
        for (SchemaWithMapping s : configuration.schemas) {
            rawScim.put("unity.endpoint.scim.schemas." + (configuration.schemas.indexOf(s) + 1), SCIMConstants.MAPPER.writeValueAsString((Object)s));
        }
        rawScim.put("unity.endpoint.scim.rootGroup", configuration.rootGroup);
        SCIMEndpointProperties propScim = new SCIMEndpointProperties(rawScim);
        RESTEndpointProperties propRest = new RESTEndpointProperties(rawRest);
        return propRest.getAsString() + "\n" + propScim.getAsString();
    }

    public static SCIMEndpointConfiguration fromProperties(String properties) {
        Properties raw = new Properties();
        try {
            raw.load(new StringReader(properties));
        }
        catch (IOException e) {
            throw new InternalException("Invalid configuration of the scim service", (Throwable)e);
        }
        SCIMEndpointProperties scimProp = new SCIMEndpointProperties(raw);
        RESTEndpointProperties restEndpointProperties = new RESTEndpointProperties(raw);
        return SCIMEndpointPropertiesConfigurationMapper.fromProperties(scimProp, restEndpointProperties);
    }

    public static SCIMEndpointConfiguration fromProperties(SCIMEndpointProperties scimProp, RESTEndpointProperties restEndpointProperties) {
        ArrayList<SchemaWithMapping> schemas = new ArrayList<SchemaWithMapping>();
        for (String schema : scimProp.getListOfValues("schemas.")) {
            try {
                schemas.add((SchemaWithMapping)SCIMConstants.MAPPER.readValue(schema, SchemaWithMapping.class));
            }
            catch (JsonProcessingException e) {
                log.error("Cannot read SCIM endpoint schema configuration", (Throwable)e);
            }
        }
        return SCIMEndpointConfiguration.builder().withAllowedCorsHeaders(restEndpointProperties.getListOfValues("allowedCorsHeaders.")).withAllowedCorsOrigins(restEndpointProperties.getListOfValues("allowedCorsOrigins.")).withSchemas(schemas).withMembershipGroups(scimProp.getListOfValues("membershipGroups.")).withMembershipAttributes(scimProp.getListOfValues("membershipAttributes.")).withRootGroup(scimProp.getValue("rootGroup")).build();
    }
}

