/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.imunity.scim.config.AttributeMapping;
import io.imunity.scim.config.DataArray;
import io.imunity.scim.console.AttributeMappingBean;
import io.imunity.scim.console.DataArrayBean;
import io.imunity.scim.console.ReferenceDataBean;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class ReferenceAttributeMapping
implements AttributeMapping {
    public static final String id = "Reference";
    public final Optional<DataArray> dataArray;
    public final ReferenceType type;
    public final String expression;

    private ReferenceAttributeMapping(Builder builder) {
        this.dataArray = builder.dataArray;
        this.type = builder.type;
        this.expression = builder.expression;
    }

    @Override
    public Optional<DataArray> getDataArray() {
        return this.dataArray;
    }

    @Override
    public String getEvaluatorId() {
        return id;
    }

    @Override
    public AttributeMappingBean toBean() {
        AttributeMappingBean bean = new AttributeMappingBean();
        bean.setDataArray(this.dataArray.isEmpty() ? new DataArrayBean() : new DataArrayBean(this.dataArray.get().type, this.dataArray.get().value));
        bean.setDataReference(new ReferenceDataBean(this.type, this.expression));
        return bean;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataArray, this.expression, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferenceAttributeMapping other = (ReferenceAttributeMapping)obj;
        return Objects.equals(this.dataArray, other.dataArray) && Objects.equals(this.expression, other.expression) && this.type == other.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<DataArray> dataArray = Optional.empty();
        private ReferenceType type;
        private String expression;

        private Builder() {
        }

        public Builder withDataArray(Optional<DataArray> dataArray) {
            this.dataArray = dataArray;
            return this;
        }

        public Builder withType(ReferenceType type) {
            this.type = type;
            return this;
        }

        public Builder withExpression(String expression) {
            this.expression = expression;
            return this;
        }

        public ReferenceAttributeMapping build() {
            return new ReferenceAttributeMapping(this);
        }
    }

    public static enum ReferenceType {
        USER,
        GROUP,
        GENERIC;

    }
}

