/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class DataArray {
    public final DataArrayType type;
    public final Optional<String> value;

    private DataArray(Builder builder) {
        this.type = builder.type;
        this.value = Optional.ofNullable(builder.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataArray other = (DataArray)obj;
        return this.type == other.type && Objects.equals(this.value, other.value);
    }

    public static final class Builder {
        private DataArrayType type;
        private String value;

        private Builder() {
        }

        public Builder withType(DataArrayType type) {
            this.type = type;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public DataArray build() {
            return new DataArray(this);
        }
    }

    public static enum DataArrayType {
        ATTRIBUTE,
        IDENTITY,
        MEMBERSHIP;

    }
}

