/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.imunity.scim.config.AttributeMapping;
import io.imunity.scim.config.DataArray;
import io.imunity.scim.console.AttributeMappingBean;
import io.imunity.scim.console.DataArrayBean;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class ComplexAttributeMapping
implements AttributeMapping {
    public static final String id = "Complex";
    public final Optional<DataArray> dataArray;

    private ComplexAttributeMapping(Builder builder) {
        this.dataArray = builder.dataArray;
    }

    @Override
    public Optional<DataArray> getDataArray() {
        return this.dataArray;
    }

    @Override
    public String getEvaluatorId() {
        return id;
    }

    @Override
    public AttributeMappingBean toBean() {
        AttributeMappingBean bean = new AttributeMappingBean();
        bean.setDataArray(this.dataArray.isEmpty() ? new DataArrayBean() : new DataArrayBean(this.dataArray.get().type, this.dataArray.get().value));
        return bean;
    }

    public int hashCode() {
        return Objects.hash(this.dataArray);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexAttributeMapping other = (ComplexAttributeMapping)obj;
        return Objects.equals(this.dataArray, other.dataArray);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<DataArray> dataArray = Optional.empty();

        private Builder() {
        }

        public Builder withDataArray(Optional<DataArray> dataArray) {
            this.dataArray = dataArray;
            return this;
        }

        public ComplexAttributeMapping build() {
            return new ComplexAttributeMapping(this);
        }
    }
}

