/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.imunity.scim.config.AttributeDefinitionWithMapping;
import io.imunity.scim.schema.SCIMAttributeType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public class AttributeDefinition {
    public final String name;
    public final SCIMAttributeType type;
    public final String description;
    public final List<AttributeDefinitionWithMapping> subAttributesWithMapping;
    public final boolean multiValued;

    private AttributeDefinition(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.subAttributesWithMapping = List.copyOf(builder.subAttributes);
        this.multiValued = builder.multiValued;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.multiValued, this.name, this.subAttributesWithMapping, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeDefinition other = (AttributeDefinition)obj;
        return Objects.equals(this.description, other.description) && this.multiValued == other.multiValued && Objects.equals(this.name, other.name) && Objects.equals(this.subAttributesWithMapping, other.subAttributesWithMapping) && this.type == other.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private SCIMAttributeType type;
        private String description;
        private List<AttributeDefinitionWithMapping> subAttributes = Collections.emptyList();
        private boolean multiValued;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(SCIMAttributeType type) {
            this.type = type;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withSubAttributesWithMapping(List<AttributeDefinitionWithMapping> subAttributes) {
            this.subAttributes = subAttributes;
            return this;
        }

        public Builder withMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
            return this;
        }

        public AttributeDefinition build() {
            return new AttributeDefinition(this);
        }
    }
}

