/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.imunity.scim.exception.SCIMException;

public enum ResourceType {
    USER("User"),
    GROUP("Group"),
    SCHEMA("Schema");

    private String name;

    private ResourceType(String name) {
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    @JsonCreator
    public static ResourceType fromName(String name) throws SCIMException {
        for (ResourceType resourceType : ResourceType.values()) {
            if (!resourceType.getName().equalsIgnoreCase(name)) continue;
            return resourceType;
        }
        throw new SCIMException(400, SCIMException.ScimErrorType.invalidSyntax, "Unknown SCIM resource type", null);
    }
}

