/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.time.Instant;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public class Meta {
    public final String resourceType;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Instant created;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Instant lastModified;
    public final URI location;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final String version;

    private Meta(Builder builder) {
        this.resourceType = builder.resourceType;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.location = builder.location;
        this.version = builder.version;
    }

    public int hashCode() {
        return Objects.hash(this.created, this.lastModified, this.location, this.resourceType, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Meta other = (Meta)obj;
        return Objects.equals(this.created, other.created) && Objects.equals(this.lastModified, other.lastModified) && Objects.equals(this.location, other.location) && this.resourceType == other.resourceType && Objects.equals(this.version, other.version);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String resourceType;
        private Instant created;
        private Instant lastModified;
        private URI location;
        private String version;

        private Builder() {
        }

        public Builder withResourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder withCreated(Instant created) {
            this.created = created;
            return this;
        }

        public Builder withLastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Builder withLocation(URI location) {
            this.location = location;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Meta build() {
            return new Meta(this);
        }
    }
}

