/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.scim.common;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.imunity.scim.common.BasicSCIMResource;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.Assert;

@JsonPropertyOrder(value={"schemas", "totalResults", "resources"})
@JsonDeserialize(builder=Builder.class)
public class ListResponse<T extends BasicSCIMResource> {
    public static final String SCHEMA = "urn:ietf:params:scim:api:messages:2.0:ListResponse";
    public final Set<String> schemas;
    public final int totalResults;
    public final List<T> resources;

    private ListResponse(Builder<T> builder) {
        this.schemas = Set.copyOf(builder.schemas);
        this.totalResults = builder.totalResults;
        this.resources = List.copyOf(builder.resources);
    }

    public int hashCode() {
        return Objects.hash(this.resources, this.schemas, this.totalResults);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListResponse other = (ListResponse)obj;
        return Objects.equals(this.resources, other.resources) && Objects.equals(this.schemas, other.schemas) && this.totalResults == other.totalResults;
    }

    public static <T extends BasicSCIMResource> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<K extends BasicSCIMResource> {
        private Set<String> schemas;
        private Integer totalResults;
        private List<K> resources = Collections.emptyList();

        private Builder() {
            this.withSchemas(Set.of(ListResponse.SCHEMA));
        }

        private Builder<K> withSchemas(Set<String> schemas) {
            this.schemas = schemas;
            return this;
        }

        public Builder<K> withTotalResults(int totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public Builder<K> withResources(List<K> resources) {
            this.resources = resources;
            return this;
        }

        public ListResponse<K> build() {
            Assert.notNull(this.schemas, (String)"schemas cannot be null.");
            Assert.notEmpty(this.schemas, (String)"schemas cannot be empty.");
            Assert.notNull((Object)this.totalResults, (String)"id cannot be null.");
            return new ListResponse(this);
        }
    }
}

